package de.pheasn.blockown.command;

import java.util.Iterator;
import java.util.Set;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.Selection;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;

public class CE_Own extends CommandExecutor {

	private static final String PARAM_SELECTION = "selection";
	private static final String PARAM_ENTITY = "e";

	private final WorldEditPlugin worldEdit;

	public CE_Own(BlockOwn plugin) {
		super(plugin);
		worldEdit = (WorldEditPlugin) plugin.getServer().getPluginManager().getPlugin("WorldEdit");
	}

	@Override
	protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		if (!player.hasPermission(Permission.OWN_OWN.toString())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
			return true;
		}

		if (!plugin.isEnabledInWorld(player.getWorld())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_DISABLED_IN_WORLD);
			return true;
		}

		User user = new User(player.getUniqueId());
		if (args.length == 1) {
			if (args[0].equalsIgnoreCase(PARAM_SELECTION)) {
				if (!player.hasPermission(Permission.OWN_OWNSELECTION.toString())) {
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
					return true;
				}
			} else if (args[0].equalsIgnoreCase(PARAM_ENTITY)) {
				if (plugin.isWaiting(user, WaitType.OWN)) {
					plugin.removeWaiting(user);
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
				} else {
					plugin.addWaiting(user, WaitType.OWN);
					plugin.getOutput().sendMessage(player, Message.COMMAND_OWN_CLICK_SOMEWHERE);
				}
				return true;
			} else {
				return false;
			}

			if (worldEdit != null) {
				Selection selection = worldEdit.getSelection(player);

				if (selection == null) {
					plugin.getOutput().sendMessage(player, Message.COMMAND_OWN_SELECTION_NOSELECTION);
					return true;
				}

				Location min = selection.getMinimumPoint();
				Location max = selection.getMaximumPoint();
				Iterator<Block> region = new RegionIterator(min, max);

				Thread t = new Thread(new OwnRunner(plugin, region, user, player), "OwnselectionThread");
				t.start();
				return true;
			} else {
				plugin.getOutput().sendMessage(player, Message.COMMAND_OWN_SELECTION_NOWORLDEDIT);
				return true;
			}

		} else if (args.length == 0) {
			Block targetBlock = player.getTargetBlock((Set<org.bukkit.Material>) null, 20);
			if (targetBlock != null) {
				OwnedBlock block = new OwnedBlock(targetBlock);
				if (plugin.isOwnEnabled(block.getMaterial())) {
					User owner = plugin.getOwningDatabase().getOwner(block);
					if (owner.isNobody()) {
						DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, block, user);
						plugin.getOwningDatabase().enqueue(databaseAction);
						plugin.getOutput().sendMessage(player, Message.COMMAND_OWN_BLOCKSUCCESS, block.getMaterial().getName());
						return true;
					} else {
						plugin.getOutput().sendMessage(player, Message.COMMAND_OWN_NOPERMISSIONFOROTHERS, owner.getName());
					}
				}
				return false;
			} else {
				plugin.getOutput().sendMessage(player, Message.COMMAND_NOTARGET);
				return false;
			}
		} else {
			return false;
		}
	}
}
