package de.pheasn.blockown.command;

import java.util.Set;

import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Material;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.protection.ProtectAction;
import de.pheasn.blockown.protection.ProtectActionType;

public class CE_Lock extends CommandExecutor {

	private static final String PARAM_ENTITY = "e";

	public CE_Lock(BlockOwn plugin) {
		super(plugin);
	}

	@Override
	protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		if (!player.hasPermission(Permission.PROTECTION_LOCK.toString())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
			return true;
		}

		if (args.length == 1) {
			User user = new User(player.getUniqueId());
			if (args[0].equalsIgnoreCase(PARAM_ENTITY)) {
				if (plugin.isWaiting(user, WaitType.LOCK)) {
					plugin.removeWaiting(user);
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
				} else {
					plugin.addWaiting(user, WaitType.LOCK);
					plugin.getOutput().sendMessage(player, Message.COMMAND_LOCK_CLICK_SOMEWHERE);
				}
				return true;
			}
			try {
				Material material = Material.parseMaterial(args[0]);
				ProtectAction protectAction = new ProtectAction(ProtectActionType.LOCK, user, material);
				plugin.getProtection().enqueue(protectAction);
				plugin.getOutput().sendMessage(player, Message.COMMAND_LOCK_SUCCESS, material.getName());
				return true;
			} catch (IllegalArgumentException e) {
				plugin.getOutput().sendMessage(player, Message.COMMAND_INVALID_MATERIAL, args[0]);
				return false;
			}
		} else if (args.length == 0) {
			Block targetBlock = player.getTargetBlock((Set<org.bukkit.Material>) null, 20);
			if (targetBlock != null) {
				Material material = (new OwnedBlock(targetBlock)).getMaterial();
				User user = new User(player.getUniqueId());
				ProtectAction protectAction = new ProtectAction(ProtectActionType.LOCK, user, material);
				plugin.getProtection().enqueue(protectAction);
				plugin.getOutput().sendMessage(player, Message.COMMAND_LOCK_SUCCESS, material.getName());
				return true;
			} else {
				plugin.getOutput().sendMessage(player, Message.COMMAND_NOTARGET);
				return false;
			}
		} else {
			return false;
		}
	}
}
