package de.pheasn.blockown.command;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.protection.ProtectAction;
import de.pheasn.blockown.protection.ProtectActionType;

public class CE_AddFriend extends CommandExecutor {

	public CE_AddFriend(BlockOwn plugin) {
		super(plugin);
	}

	@Override
	protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		if (!player.hasPermission(Permission.PROTECTION_ADDFRIEND.toString())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
			return true;
		}

		if (args.length != 1) {
			return false;
		}

		User user = new User(player.getUniqueId());
		@SuppressWarnings("deprecation")
		OfflinePlayer friendPlayer = plugin.getServer().getOfflinePlayer(args[0]);
		if (!friendPlayer.hasPlayedBefore()) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_INVALID_PLAYER, args[0]);
			return false;
		}

		User friend = new User(friendPlayer.getUniqueId());
		ProtectAction protectAction = new ProtectAction(ProtectActionType.FRIEND, user, friend);
		plugin.getProtection().enqueue(protectAction);
		plugin.getOutput().sendMessage(player, Message.COMMAND_ADDFRIEND_SUCCESS, friendPlayer.getName());
		return true;
	}
}
