package de.pheasn.blockown;

import java.lang.ref.WeakReference;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;

public class OwnedBlock implements Ownable {

	private static final long serialVersionUID = 4996349639615230112L;

	private transient WeakReference<Block> blockRef;

	private final String worldName;
	private final int x, y, z;
	private transient Material material;

	public OwnedBlock(Block block) {
		World world = block.getWorld();
		worldName = world.getName();
		x = block.getX();
		y = block.getY();
		z = block.getZ();
		material = new Material(block.getType());

		this.blockRef = new WeakReference<Block>(block);
	}

	public OwnedBlock(String worldName, int x, int y, int z, Material material) {
		this.worldName = worldName;
		this.x = x;
		this.y = y;
		this.z = z;
		this.material = material;
	}

	public OwnedBlock(String worldName, int x, int y, int z) {
		this.worldName = worldName;
		this.x = x;
		this.y = y;
		this.z = z;
		material = null;
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	public int getZ() {
		return z;
	}

	@Override
	public World getWorld() {
		return Bukkit.getServer().getWorld(worldName);
	}

	public Block getBlock() {
		Block result = (blockRef == null) ? null : blockRef.get();
		if (result == null) {
			result = getWorld().getBlockAt(x, y, z);
			blockRef = new WeakReference<Block>(result);
		}
		return result;
	}

	@Override
	public String getWorldName() {
		return worldName;
	}

	@Override
	public Material getMaterial() {
		if(material == null) {
			try {
				material = new Material(Bukkit.getServer().getWorld(worldName).getBlockAt(x, y, z).getType());
			} catch (Exception e) {
				return null;
			}
		}
		return material;
	}

	@Override
	public int hashCode() {
		final int prime = 41;
		int result = 1733;
		result = prime * result + ((worldName == null) ? 0 : worldName.hashCode());
		result = prime * result + x;
		result = prime * result + y;
		result = prime * result + z;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		OwnedBlock other = (OwnedBlock) obj;
		if (worldName == null) {
			if (other.worldName != null) return false;
		} else if (!worldName.equals(other.worldName)) return false;
		if (x != other.x) return false;
		if (y != other.y) return false;
		if (z != other.z) return false;
		return true;
	}

	@Override
	public String toString() {
		return "OwnedBlock [block=" + getWorldName() + ":" + getX() + "," + getY() + "," + getZ() + "]";
	}
}
