package de.pheasn.blockown;

import java.io.Serializable;

import org.bukkit.entity.EntityType;
import org.bukkit.material.MaterialData;

public class Material implements Serializable {

	private static final long serialVersionUID = -3658668250059098095L;
	public static final String ANY_STRING = "ALL";
	public static final Material ANY = new Material(true);

	private final boolean isBlock;
	private final EntityType entityType;
	private final org.bukkit.Material material;

	private Material(boolean isBlock) {
		this.isBlock = isBlock;
		this.entityType = null;
		this.material = null;
	}

	public Material(org.bukkit.Material material) {
		this.isBlock = true;
		this.material = material;
		this.entityType = null;
	}

	public Material(EntityType entityType) {
		this.isBlock = false;
		this.material = null;
		this.entityType = entityType;
	}

	public EntityType getEntityType() {
		return entityType;
	}

	public org.bukkit.Material getMaterial() {
		return material;
	}

	public Class<? extends MaterialData> getData() {
		return material.getData();
	}

	public boolean isAny() {
		return (material == null && entityType == null);
	}

	public boolean isBlock() {
		return isBlock;
	}

	public String getName() {
		if (isAny()) {
			return ANY_STRING;
		} else {
			if (isBlock()) {
				return material.toString();
			} else {
				return entityType.toString();
			}
		}
	}

	@SuppressWarnings("deprecation")
	public static Material parseMaterial(String materialName) {
		if (materialName.equalsIgnoreCase(ANY_STRING)) return ANY;

		EntityType t = null;
		try {
			t = EntityType.valueOf(materialName.toUpperCase());
		} catch (IllegalArgumentException e) {
		}
		if (t != null) return new Material(t);

		org.bukkit.Material m;
		try {
			int id = Integer.parseInt(materialName);
			m = org.bukkit.Material.getMaterial(id);
		} catch (NumberFormatException e) {
			m = org.bukkit.Material.matchMaterial(materialName);
		}
		if (m != null) return new Material(m);

		throw new IllegalArgumentException();
	}

	@Override
	public int hashCode() {
		final int prime = 59;
		int result = 1;
		result = prime * result + ((entityType == null) ? 0 : entityType.hashCode());
		result = prime * result + (isBlock ? 1231 : 1237);
		result = prime * result + ((material == null) ? 0 : material.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		Material other = (Material) obj;
		if (isBlock != other.isBlock) return false;
		if (entityType != other.entityType) return false;
		if (material != other.material) return false;
		return true;
	}

	@Override
	public String toString() {
		return getName();
	}
}
