package de.pheasn.blockown;

import java.text.MessageFormat;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class DefaultOutput implements Output {

	private static final String pluginName = "[BlockOwn] ";

	private ConsoleCommandSender console;

	DefaultOutput() {
		console = Bukkit.getServer().getConsoleSender();
	}

	/**
	 * Prints out "An exception occurred" to the console
	 *
	 * @param e
	 *            the exception
	 */
	@Override
	public void printException(Exception e) {
		// Don't bug normal users with exception details
		printConsole(Message.getChatColor(Message.COLOR_ERROR) + "An exception occurred.");
	}

	/**
	 * Prints the message to console
	 *
	 * @param message
	 *            the message. Should be user readable
	 */
	@Override
	public void printException(String message) {
		// Don't bug normal users with exception details
		printConsole(Message.getChatColor(Message.COLOR_ERROR) + message);
	}

	/**
	 * Prints the message to console
	 * 
	 * @param message
	 *            the message, Should be user readable
	 * @param e
	 *            the exception
	 */
	@Override
	public void printException(String message, Exception e) {
		printException(Message.getChatColor(Message.COLOR_ERROR) + message);
	}

	/**
	 * Prints message to console.
	 *
	 * @param message
	 *            the message
	 */
	@Override
	public void printConsole(Message message) {
		console.sendMessage(pluginName + message.toString());
	}

	@Override
	public void printConsole(String message) {
		console.sendMessage(pluginName + message);
	}

	/**
	 * Send a message to a CommandSender
	 *
	 * @param sender
	 *            the sender
	 * @param message
	 *            the message
	 */
	@Override
	public void sendMessage(CommandSender sender, Message message) {
		if (message.toString().isEmpty()) return;
		if (sender instanceof Player) {
			sender.sendMessage(message.toString());
		} else {
			printConsole(message);
		}
	}

	/**
	 * Send a CommandSender a message
	 *
	 * @param sender
	 *            the sender
	 * @param message
	 *            the message
	 * @param params
	 *            the parameters
	 */
	@Override
	public void sendMessage(CommandSender sender, Message message, Object... params) {
		if (message.toString().isEmpty()) return;
		String messageString = MessageFormat.format(message.toString(), params);
		if (sender instanceof Player) {
			sender.sendMessage(messageString);
		} else {
			printConsole(messageString);
		}
	}

	/**
	 * Broadcast a message on the whole server
	 * 
	 * @param message
	 *            the message
	 */
	@Override
	public void broadcast(Message message) {
		printConsole(message);
		for (World world : Bukkit.getServer().getWorlds()) {
			broadcastInWorld(world, message);
		}
	}

	/**
	 * Broadcast a message in a specific world
	 * 
	 * @param world
	 *            the world
	 * @param message
	 *            the message
	 */
	@Override
	public void broadcast(World world, Message message) {
		printConsole(message);
		broadcastInWorld(world, message);
	}

	private void broadcastInWorld(World world, Message message) {
		for (Player player : world.getPlayers()) {
			player.sendMessage(message.toString());
		}
	}

	/**
	 * Prints a debug message
	 * 
	 * @param message
	 *            the message
	 */
	@Override
	public void debugMessage(String message) {
		// Don't print debug Messages in normal output mode
	}
}
