package de.pheasn.blockown.protection;

import java.text.SimpleDateFormat;
import java.util.Date;

import de.pheasn.blockown.Material;
import de.pheasn.blockown.User;

public class ProtectAction {

	private final ProtectActionType protectActionType;
	private final User owner;
	private final User user;
	private final Material material;
	private final long timeStamp;

	/**
	 * 
	 * @param protectActionType
	 * @param owner
	 *            Must not be null
	 * @param material
	 *            may be null or left out depending on action type
	 * @param user
	 *            may be null or left out depending on action type
	 */
	public ProtectAction(ProtectActionType protectActionType, User owner, Material material, User user) {
		this.protectActionType = protectActionType;
		this.owner = owner;
		this.material = material;
		this.user = user;
		this.timeStamp = System.currentTimeMillis();
	}

	/**
	 * May be used with protectActionType == PROTECT or UNPROTECT or LOCK or UNLOCK
	 * 
	 * @param protectActionType
	 * @param owner
	 * @param material
	 */
	public ProtectAction(ProtectActionType protectActionType, User owner, Material material) {
		this(protectActionType, owner, material, null);
	}

	/**
	 * May only be used with protectActionType == FRIEND or UNFRIEND
	 * 
	 * @param protectActionType
	 * @param owner
	 * @param user
	 */
	public ProtectAction(ProtectActionType protectActionType, User owner, User user) {
		this(protectActionType, owner, null, user);
	}

	/**
	 * May only be used with protectActionType == DROP
	 *
	 * @param protectActionType
	 * @param user
	 */
	public ProtectAction(ProtectActionType protectActionType, User user) {
		this(protectActionType, null, null, user);
	}

	public ProtectActionType getActionType() {
		return protectActionType;
	}

	public User getOwner() {
		return owner;
	}

	public User getUser() {
		return user;
	}

	public Material getMaterial() {
		return material;
	}

	public long getTimeStamp() {
		return timeStamp;
	}

	@Override
	public int hashCode() {
		final int prime = 23;
		int result = 1;
		result = prime * result + ((material == null) ? 0 : material.hashCode());
		result = prime * result + ((owner == null) ? 0 : owner.hashCode());
		result = prime * result + ((protectActionType == null) ? 0 : protectActionType.hashCode());
		result = prime * result + (int) (timeStamp ^ (timeStamp >>> 32));
		result = prime * result + ((user == null) ? 0 : user.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		ProtectAction other = (ProtectAction) obj;
		if (material == null) {
			if (other.material != null) return false;
		} else if (!material.equals(other.material)) return false;
		if (owner == null) {
			if (other.owner != null) return false;
		} else if (!owner.equals(other.owner)) return false;
		if (protectActionType != other.protectActionType) return false;
		if (timeStamp != other.timeStamp) return false;
		if (user == null) {
			if (other.user != null) return false;
		} else if (!user.equals(other.user)) return false;
		return true;
	}

	@Override
	public String toString() {
		return "ProtectAction [protectActionType=" + protectActionType + ", owner=" + owner + ", user=" + user + ", material=" + material + ", timeStamp="
				+ new SimpleDateFormat().format(new Date(timeStamp)) + "]";
	}
}
