package de.pheasn.blockown.event;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDamageEvent.DamageCause;
import org.bukkit.event.entity.EntityExplodeEvent;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.Setting;
import de.pheasn.blockown.User;

public class L_EnvironmentDamage extends Listener {

	private final Set<DamageCause> environmentDamages;

	public L_EnvironmentDamage(BlockOwn plugin) {
		super(plugin);
		environmentDamages = new HashSet<DamageCause>(8, 1);
		environmentDamages.addAll(Arrays.asList(new DamageCause[] {
				DamageCause.BLOCK_EXPLOSION,
				DamageCause.ENTITY_EXPLOSION,
				DamageCause.FALL,
				DamageCause.FALLING_BLOCK,
				DamageCause.FIRE,
				DamageCause.FIRE_TICK,
				DamageCause.LIGHTNING,
				DamageCause.PROJECTILE
		}));
	}

	@EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
	public void onBlockBurn(BlockBurnEvent event) {
		if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get()) return;
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = new OwnedBlock(event.getBlock());

		if (!validAccess(block)) {
			event.setCancelled(true);
		}
	}

	@EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
	public void onEntityDamage(EntityDamageEvent event) {
		if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get()) return;
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
		if (!isProtectedDamageCause(event.getCause())) return;
		OwnedEntity entity = new OwnedEntity(event.getEntity());

		if (!validAccess(entity)) {
			event.setCancelled(true);
		}
	}

	@EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
	public void onWaterBreak(BlockFromToEvent event) {
		if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get()) return;
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = new OwnedBlock(event.getToBlock());

		if (!validAccess(block)) {
			event.setCancelled(true);
		}
	}

	@EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
	public void onPistonExtend(BlockPistonExtendEvent event) {
		if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get()) return;
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block;
		for (Block nativeBlock : event.getBlocks()) {
			block = new OwnedBlock(nativeBlock);
			if (!validAccess(block)) {
				event.setCancelled(true);
				return;
			}
		}
	}

	@EventHandler(priority = EventPriority.HIGH, ignoreCancelled = true)
	public void onBlockExploded(EntityExplodeEvent event) {
		if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get()) return;
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
		Iterator<Block> iterator = event.blockList().iterator();
		OwnedBlock block;

		while (iterator.hasNext()) {
			block = new OwnedBlock(iterator.next());
			if (!validAccess(block)) {
				iterator.remove();
			}
		}
	}

	@EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
	public void onEntityTrample(EntityChangeBlockEvent event) {
		if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get()) return;
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld()))	return;
		if (!(event.getEntity() instanceof HumanEntity)) {
			OwnedBlock block = new OwnedBlock(event.getBlock());
			if (!validAccess(block)) {
				event.setCancelled(true);
			}
		}
	}

	private boolean validAccess(Ownable ownable) {
		if (plugin.isOwnEnabled(ownable.getMaterial())) {
			User owner = plugin.getOwningDatabase().getOwner(ownable);
			if (!owner.isNobody()) {
				if (plugin.getProtection().isProtected(owner, ownable.getMaterial()) || plugin.getProtection().isLocked(owner, ownable.getMaterial())) {
					return false;
				}
			}
		}

		if (ownable instanceof OwnedBlock) {
			Block block = ((OwnedBlock) ownable).getBlock();
			for (Block attachedBlock : getAttachedBlocks(block)) {
				OwnedBlock attachedOwned = new OwnedBlock(attachedBlock);
				User attachedOwner = plugin.getOwningDatabase().getOwner(attachedOwned);
				if (attachedOwner.isNobody()) continue;
				if (plugin.getProtection().isProtected(attachedOwner, attachedOwned.getMaterial())
						|| plugin.getProtection().isLocked(attachedOwner, attachedOwned.getMaterial())) {
					return false;
				}
			}
		}
		return true;
	}

	private boolean isProtectedDamageCause(DamageCause cause) {
		return environmentDamages.contains(cause);
	}
}
