package de.pheasn.blockown.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

import de.pheasn.blockown.Output;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;

public class SqliteDatabase extends CachedDatabase {

	private static final String FILENAME = "world.db";
	private final File pluginDataFolder;

	public SqliteDatabase(Output output, File pluginFolder) throws SQLException, ClassNotFoundException {
		super(output, pluginFolder);
		this.pluginDataFolder = pluginFolder.getAbsoluteFile();
		Class.forName("org.sqlite.JDBC");
		connection = connect();
		createTables();
	}

	private Connection connect() throws SQLException {
		File file = new File(pluginDataFolder, FILENAME);
		String url = "jdbc:sqlite:" + file.getPath();
		return DriverManager.getConnection(url);
	}

	private void createTables() throws SQLException {
		Statement stmnt = connection.createStatement();
		String query = null;
		query = generateCreateBlockTableQuery();
		stmnt.executeUpdate(query);
		query = generateCreateEntityTableQuery();
		stmnt.executeUpdate(query);
		stmnt.close();
	}

	@Override
	protected String generateCreateBlockTableQuery() {
		StringBuilder query = new StringBuilder(200);
		query.append("CREATE TABLE IF NOT EXISTS ").append(BLOCK_TABLE).append(" (")
				.append(WORLD_COLUMN).append(" VARCHAR(50), ")
				.append(X_COLUMN).append(" INT, ")
				.append(Y_COLUMN).append(" INT, ")
				.append(Z_COLUMN).append(" INT, ")
				.append(PLAYER_ID_COLUMN).append(" CHAR(36) NOT NULL, ")
				.append("PRIMARY KEY (").append(WORLD_COLUMN).append(", ")
				.append(X_COLUMN).append(", ").append(Y_COLUMN).append(", ")
				.append(Z_COLUMN).append("));");
		return query.toString();
	}

	@Override
	protected String generateCreateEntityTableQuery() {
		StringBuilder query = new StringBuilder(200);
		query.append("CREATE TABLE IF NOT EXISTS ").append(ENTITY_TABLE).append(" (")
				.append(WORLD_COLUMN).append(" VARCHAR(50) NOT NULL, ")
				.append(ENTITY_ID_COLUMN).append(" CHAR(36), ")
				.append(PLAYER_ID_COLUMN).append(" CHAR(36) NOT NULL, ")
				.append("PRIMARY KEY (").append(ENTITY_ID_COLUMN).append("));");
		return query.toString();
	}

	@Override
	protected String generateGetOwnerQuery(OwnedBlock block) {
		StringBuilder query = new StringBuilder(200);
		query.append("SELECT ").append(PLAYER_ID_COLUMN).append(" FROM ").append(BLOCK_TABLE).append(" WHERE ")
				.append(WORLD_COLUMN).append("='").append(block.getWorldName()).append("' AND ")
				.append(X_COLUMN).append("=").append(block.getX()).append(" AND ")
				.append(Y_COLUMN).append("=").append(block.getY()).append(" AND ")
				.append(Z_COLUMN).append("=").append(block.getZ()).append(";");
		return query.toString();
	}

	@Override
	protected String generateGetOwnerQuery(OwnedEntity entity) {
		StringBuilder query = new StringBuilder(200);
		query.append("SELECT ").append(PLAYER_ID_COLUMN).append(" FROM ").append(ENTITY_TABLE).append(" WHERE ")
				.append(WORLD_COLUMN).append("='").append(entity.getWorldName()).append("' AND ")
				.append(ENTITY_ID_COLUMN).append("='").append(entity.getUniqueId().toString()).append("';");
		return query.toString();
	}

	@Override
	protected String generateSetBlockOwnerQuery(DatabaseAction databaseAction) {
		OwnedBlock block = (OwnedBlock) databaseAction.getOwnable();
		String worldName = databaseAction.getOwnable().getWorldName();
		String playerId = databaseAction.getUser().getId().toString();
		int x = block.getX();
		int y = block.getY();
		int z = block.getZ();
		StringBuilder query = new StringBuilder(200);
		query.append("INSERT OR REPLACE INTO ").append(BLOCK_TABLE).append("(")
				.append(WORLD_COLUMN).append(", ").append(X_COLUMN).append(", ")
				.append(Y_COLUMN).append(", ").append(Z_COLUMN).append(", ")
				.append(PLAYER_ID_COLUMN).append(") VALUES('")
				.append(worldName).append("', '").append(x).append("', '")
				.append(y).append("', '").append(z).append("', '").append(playerId).append("');");
		return query.toString();
	}

	@Override
	protected String generateSetEntityOwnerQuery(DatabaseAction databaseAction) {
		OwnedEntity entity = (OwnedEntity) databaseAction.getOwnable();
		String worldName = databaseAction.getOwnable().getWorldName();
		String playerId = databaseAction.getUser().getId().toString();
		UUID entityId = entity.getUniqueId();
		StringBuilder query = new StringBuilder(200);
		query.append("INSERT OR REPLACE INTO ").append(ENTITY_TABLE).append("(")
				.append(WORLD_COLUMN).append(", ").append(ENTITY_ID_COLUMN).append(", ")
				.append(PLAYER_ID_COLUMN).append(") VALUES('")
				.append(worldName).append("', '").append(entityId.toString()).append("', '")
				.append(playerId).append("');");
		return query.toString();
	}

	@Override
	protected String generateDeleteOwnerQuery(OwnedEntity entity) {
		StringBuilder query = new StringBuilder(200);
		query.append("DELETE FROM ").append(ENTITY_TABLE).append(" WHERE ")
				.append(WORLD_COLUMN).append("='").append(entity.getWorldName()).append("' AND ")
				.append(ENTITY_ID_COLUMN).append("='").append(entity.getUniqueId().toString()).append("';");
		return query.toString();
	}

	@Override
	protected String generateDeleteOwnerQuery(OwnedBlock block) {
		StringBuilder query = new StringBuilder(200);
		query.append("DELETE FROM ").append(BLOCK_TABLE).append(" WHERE ")
				.append(WORLD_COLUMN).append("='").append(block.getWorldName()).append("' AND ")
				.append(X_COLUMN).append("=").append(block.getX()).append(" AND ")
				.append(Y_COLUMN).append("=").append(block.getY()).append(" AND ")
				.append(Z_COLUMN).append("=").append(block.getZ()).append(";");
		return query.toString();
	}

	@Override
	protected String generateDropUserBlocksQuery(User user) {
		StringBuilder query = new StringBuilder(150);
		query.append("DELETE FROM ").append(BLOCK_TABLE).append(" WHERE ")
				.append(PLAYER_ID_COLUMN).append("='").append(user.getId().toString()).append("';");
		return query.toString();
	}

	@Override
	protected String generateDropUserEntitiesQuery(User user) {
		StringBuilder query = new StringBuilder(150);
		query.append("DELETE FROM ").append(ENTITY_TABLE).append(" WHERE ")
				.append(PLAYER_ID_COLUMN).append("='").append(user.getId().toString()).append("';");
		return query.toString();
	}

}
