package de.pheasn.blockown.database;

import java.io.File;

import de.pheasn.blockown.Output;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.User;

public abstract class CachedDatabase extends Database {

	private final Cache cache;

	protected CachedDatabase(Output output, File pluginFolder) {
		super(output);
		cache = new Cache(this, pluginFolder);
	}

	@Override
	public User getOwner(Ownable ownable) {
		return cache.getOwner(ownable);
	}

	@Override
	public void run() {
		DatabaseAction databaseAction;
		while (!disable || !queue.isEmpty()) {
			if (!queue.isEmpty()) {
				databaseAction = queue.remove();
				if (!cache.doAction(databaseAction)) {
					getOutput().printException(new ActionNotPerformedException(databaseAction));
				}
			} else {
				cache.flush();
				if (disable || !queue.isEmpty()) continue;
				try {
					synchronized (LOCK) {
						while (!disable && queue.isEmpty()) {
							LOCK.wait();
						}
					}
				} catch (InterruptedException e) {
					getOutput().printException("Database thread has been interrupted.", e);
				}
			}
		}
		// Flush cache before thread is ending
		cache.flush();
		close();
	}
}
