package de.pheasn.blockown.command;

import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;

public abstract class CommandExecutor implements org.bukkit.command.CommandExecutor {

	protected final BlockOwn plugin;

	public CommandExecutor(BlockOwn plugin) {
		this.plugin = plugin;
	}

	@Override
	public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
		if (sender instanceof Player) {
			return performCommand((Player) sender, cmd, cmdName, args);
		} else {
			plugin.getOutput().sendMessage(sender, Message.COMMAND_PLAYERS_ONLY);
			return true;
		}
	}

	/**
	 * @author Njol (bukkit forums)
	 */
	protected <T extends Entity> T getTarget(Location eyeLocation, Iterable<T> entities) {
		T target = null;
		double threshold = 1;
		for (T other : entities) {
			Vector n = other.getLocation().toVector().subtract(eyeLocation.getDirection());
			if (eyeLocation.getDirection().normalize().crossProduct(n).lengthSquared() < threshold && n.normalize().dot(eyeLocation.getDirection().normalize()) >= 0) {
				if (target == null || target.getLocation().distanceSquared(eyeLocation) > other.getLocation().distanceSquared(eyeLocation)) target = other;
			}
		}
		return target;
	}

	protected abstract boolean performCommand(Player player, Command cmd, String cmdName, String[] args);
}
