package de.pheasn.blockown.command;

import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Material;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.protection.ProtectAction;
import de.pheasn.blockown.protection.ProtectActionType;

public class CE_Protect extends CommandExecutor {

	private static final String PARAM_ENTITY = "e";

	public CE_Protect(BlockOwn plugin) {
		super(plugin);
	}

	@Override
	protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		if (!player.hasPermission(Permission.PROTECTION_PROTECT.toString())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
			return true;
		}

		if (args.length == 1) {
			User user = new User(player.getUniqueId());
			if (args[0].equalsIgnoreCase(PARAM_ENTITY)) {
				if (plugin.isWaiting(user, WaitType.PROTECT)) {
					plugin.removeWaiting(user);
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
				} else {
					plugin.addWaiting(user, WaitType.PROTECT);
					plugin.getOutput().sendMessage(player, Message.COMMAND_PROTECT_CLICK_SOMEWHERE);
				}
				return true;
			}
			try {
				Material material = Material.parseMaterial(args[0]);
				ProtectAction protectAction = new ProtectAction(ProtectActionType.PROTECT, user, material);
				plugin.getProtection().enqueue(protectAction);
				plugin.getOutput().sendMessage(player, Message.COMMAND_PROTECT_SUCCESS, material.getName());
				return true;
			} catch (IllegalArgumentException e) {
				plugin.getOutput().sendMessage(player, Message.COMMAND_INVALID_MATERIAL, args[0]);
				return false;
			}
		} else if (args.length == 0) {
			@SuppressWarnings("deprecation")
			Block targetBlock = player.getTargetBlock(null, 20);
			if (targetBlock != null) {
				Material material = (new OwnedBlock(targetBlock)).getMaterial();
				User user = new User(player.getUniqueId());
				ProtectAction protectAction = new ProtectAction(ProtectActionType.PROTECT, user, material);
				plugin.getProtection().enqueue(protectAction);
				plugin.getOutput().sendMessage(player, Message.COMMAND_PROTECT_SUCCESS, material.getName());
				return true;
			} else {
				plugin.getOutput().sendMessage(player, Message.COMMAND_NOTARGET);
				return false;
			}
		} else {
			return false;
		}
	}

}
