package de.pheasn.blockown;

import org.bukkit.World;
import org.bukkit.command.CommandSender;

public interface Output {
	/**
	 * Prints out "An exception occurred" to the console
	 *
	 * @param e
	 *            the exception
	 */
	public void printException(Exception e);

	/**
	 * Prints the message to console
	 *
	 * @param message
	 *            the message. Should be user readable
	 */
	public void printException(String message);

	/**
	 * Prints the message to console
	 * 
	 * @param message
	 *            the message, Should be user readable
	 * @param e
	 *            the exception
	 */
	public void printException(String message, Exception e);

	/**
	 * Prints message to console.
	 *
	 * @param message
	 *            the message
	 */
	public void printConsole(Message message);

	/**
	 * Prints string message to console.
	 *
	 * @param message
	 *            the message
	 */
	public void printConsole(String message);

	/**
	 * Send a message to a CommandSender
	 *
	 * @param sender
	 *            the sender
	 * @param message
	 *            the message
	 */
	public void sendMessage(CommandSender sender, Message message);

	/**
	 * Send a CommandSender a message
	 *
	 * @param sender
	 *            the sender
	 * @param message
	 *            the message
	 * @param params
	 *            the parameters
	 */
	public void sendMessage(CommandSender sender, Message message, Object... params);

	/**
	 * Broadcast a message on the whole server
	 * 
	 * @param message
	 *            the message
	 */
	public void broadcast(Message message);

	/**
	 * Broadcast a message in a specific world
	 * 
	 * @param world
	 *            the world
	 * @param message
	 *            the message
	 */
	public void broadcast(World world, Message message);

	/**
	 * Prints a debug message
	 * 
	 * @param message
	 *            the message
	 */
	public void debugMessage(String message);
}
