/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.protection;

import de.pheasn.blockown.Material;
import de.pheasn.blockown.User;
import de.pheasn.blockown.protection.ProtectActionType;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ProtectAction {
    private final ProtectActionType protectActionType;
    private final User owner;
    private final User user;
    private final Material material;
    private final long timeStamp;

    public ProtectAction(ProtectActionType protectActionType, User owner, Material material, User user) {
        this.protectActionType = protectActionType;
        this.owner = owner;
        this.material = material;
        this.user = user;
        this.timeStamp = System.currentTimeMillis();
    }

    public ProtectAction(ProtectActionType protectActionType, User owner, Material material) {
        this(protectActionType, owner, material, null);
    }

    public ProtectAction(ProtectActionType protectActionType, User owner, User user) {
        this(protectActionType, owner, null, user);
    }

    public ProtectAction(ProtectActionType protectActionType, User user) {
        this(protectActionType, null, null, user);
    }

    public ProtectActionType getActionType() {
        return this.protectActionType;
    }

    public User getOwner() {
        return this.owner;
    }

    public User getUser() {
        return this.user;
    }

    public Material getMaterial() {
        return this.material;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int hashCode() {
        int prime = 23;
        int result = 1;
        result = 23 * result + (this.material == null ? 0 : this.material.hashCode());
        result = 23 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 23 * result + (this.protectActionType == null ? 0 : this.protectActionType.hashCode());
        result = 23 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        result = 23 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtectAction other = (ProtectAction)obj;
        if (this.material == null ? other.material != null : !this.material.equals(other.material)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.protectActionType != other.protectActionType) {
            return false;
        }
        if (this.timeStamp != other.timeStamp) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String toString() {
        return "ProtectAction [protectActionType=" + (Object)((Object)this.protectActionType) + ", owner=" + this.owner + ", user=" + this.user + ", material=" + this.material + ", timeStamp=" + new SimpleDateFormat().format(new Date(this.timeStamp)) + "]";
    }
}

