/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.importer;

import de.pheasn.blockown.User;
import de.pheasn.blockown.database.Database;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;

public abstract class Importer
implements Runnable {
    public static boolean debug = false;
    protected final Database db;
    protected final File pluginsFolder;
    private final Runnable runnable;

    protected Importer(Database db, File pluginsFolder, Runnable runnable) {
        this.db = db;
        this.pluginsFolder = pluginsFolder;
        this.runnable = runnable;
    }

    @Override
    public abstract void run();

    protected void finished() {
        this.runnable.run();
    }

    protected synchronized HashMap<UUID, EntityType> getEntities() {
        HashMap<UUID, EntityType> entities = new HashMap<UUID, EntityType>(2048);
        for (World world : Bukkit.getServer().getWorlds()) {
            for (Entity entity : world.getEntities()) {
                entities.put(entity.getUniqueId(), entity.getType());
            }
        }
        return entities;
    }

    protected synchronized User getUser(String name) {
        UUID id = Bukkit.getServer().getOfflinePlayer(name).getUniqueId();
        if (id == null) {
            return new User(id);
        }
        return null;
    }

    protected synchronized ItemFrame getItemFrame(String worldName, int x, int y, int z) {
        World world = Bukkit.getServer().getWorld(worldName);
        if (world == null) {
            return null;
        }
        Location loc = new Location(world, (double)x, (double)y, (double)z);
        for (Entity entity : loc.getChunk().getEntities()) {
            if (!(entity instanceof ItemFrame) || entity.getLocation().getBlockX() != loc.getBlockX() || entity.getLocation().getBlockY() != loc.getBlockY() || entity.getLocation().getBlockZ() != loc.getBlockZ()) continue;
            return (ItemFrame)entity;
        }
        return null;
    }
}

