/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.event;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.Setting;
import de.pheasn.blockown.User;
import de.pheasn.blockown.event.Listener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.block.Block;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;

public class L_EnvironmentDamage
extends Listener {
    private final Set<EntityDamageEvent.DamageCause> environmentDamages = new HashSet<EntityDamageEvent.DamageCause>(8, 1.0f);

    public L_EnvironmentDamage(BlockOwn plugin) {
        super(plugin);
        this.environmentDamages.addAll(Arrays.asList(EntityDamageEvent.DamageCause.BLOCK_EXPLOSION, EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, EntityDamageEvent.DamageCause.FALL, EntityDamageEvent.DamageCause.FALLING_BLOCK, EntityDamageEvent.DamageCause.FIRE, EntityDamageEvent.DamageCause.FIRE_TICK, EntityDamageEvent.DamageCause.LIGHTNING, EntityDamageEvent.DamageCause.PROJECTILE));
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        OwnedBlock block = new OwnedBlock(event.getBlock());
        if (!this.validAccess(block)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDamage(EntityDamageEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!this.isProtectedDamageCause(event.getCause())) {
            return;
        }
        OwnedEntity entity = new OwnedEntity(event.getEntity());
        if (!this.validAccess(entity)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onWaterBreak(BlockFromToEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        OwnedBlock block = new OwnedBlock(event.getToBlock());
        if (!this.validAccess(block)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        for (Block nativeBlock : event.getBlocks()) {
            OwnedBlock block = new OwnedBlock(nativeBlock);
            if (this.validAccess(block)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockExploded(EntityExplodeEvent event) {
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getEntity().getWorld())) {
            return;
        }
        Iterator iterator = event.blockList().iterator();
        while (iterator.hasNext()) {
            OwnedBlock block = new OwnedBlock((Block)iterator.next());
            if (this.validAccess(block)) continue;
            iterator.remove();
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityTrample(EntityChangeBlockEvent event) {
        OwnedBlock block;
        if (!Setting.PROTECTION_PROTECT_AGAINST_ENVIRONMENT.get().booleanValue()) {
            return;
        }
        if (!this.plugin.isEnabledInWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!(event.getEntity() instanceof HumanEntity) && !this.validAccess(block = new OwnedBlock(event.getBlock()))) {
            event.setCancelled(true);
        }
    }

    private boolean validAccess(Ownable ownable) {
        User owner;
        if (this.plugin.isOwnEnabled(ownable.getMaterial()) && !(owner = this.plugin.getOwningDatabase().getOwner(ownable)).isNobody() && (this.plugin.getProtection().isProtected(owner, ownable.getMaterial()) || this.plugin.getProtection().isLocked(owner, ownable.getMaterial()))) {
            return false;
        }
        if (ownable instanceof OwnedBlock) {
            Block block = ((OwnedBlock)ownable).getBlock();
            for (Block attachedBlock : this.getAttachedBlocks(block)) {
                OwnedBlock attachedOwned = new OwnedBlock(attachedBlock);
                User attachedOwner = this.plugin.getOwningDatabase().getOwner(attachedOwned);
                if (attachedOwner.isNobody() || !this.plugin.getProtection().isProtected(attachedOwner, attachedOwned.getMaterial()) && !this.plugin.getProtection().isLocked(attachedOwner, attachedOwned.getMaterial())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isProtectedDamageCause(EntityDamageEvent.DamageCause cause) {
        return this.environmentDamages.contains(cause);
    }
}

