/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import de.pheasn.blockown.Output;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.CachedDatabase;
import de.pheasn.blockown.database.DatabaseAction;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

public class SqliteDatabase
extends CachedDatabase {
    private static final String FILENAME = "world.db";
    private final File pluginDataFolder;

    public SqliteDatabase(Output output, File pluginFolder) throws SQLException, ClassNotFoundException {
        super(output, pluginFolder);
        this.pluginDataFolder = pluginFolder.getAbsoluteFile();
        Class.forName("org.sqlite.JDBC");
        this.connection = this.connect();
        this.createTables();
    }

    private Connection connect() throws SQLException {
        File file = new File(this.pluginDataFolder, FILENAME);
        String url = "jdbc:sqlite:" + file.getPath();
        return DriverManager.getConnection(url);
    }

    private void createTables() throws SQLException {
        Statement stmnt = this.connection.createStatement();
        String query = null;
        query = this.generateCreateBlockTableQuery();
        stmnt.executeUpdate(query);
        query = this.generateCreateEntityTableQuery();
        stmnt.executeUpdate(query);
        stmnt.close();
    }

    @Override
    protected String generateCreateBlockTableQuery() {
        StringBuilder query = new StringBuilder(200);
        query.append("CREATE TABLE IF NOT EXISTS ").append("block_table").append(" (").append("world").append(" VARCHAR(50), ").append("x").append(" INT, ").append("y").append(" INT, ").append("z").append(" INT, ").append("player_id").append(" CHAR(36) NOT NULL, ").append("PRIMARY KEY (").append("world").append(", ").append("x").append(", ").append("y").append(", ").append("z").append("));");
        return query.toString();
    }

    @Override
    protected String generateCreateEntityTableQuery() {
        StringBuilder query = new StringBuilder(200);
        query.append("CREATE TABLE IF NOT EXISTS ").append("entity_table").append(" (").append("world").append(" VARCHAR(50) NOT NULL, ").append("entity_id").append(" CHAR(36), ").append("player_id").append(" CHAR(36) NOT NULL, ").append("PRIMARY KEY (").append("entity_id").append("));");
        return query.toString();
    }

    @Override
    protected String generateGetOwnerQuery(OwnedBlock block) {
        StringBuilder query = new StringBuilder(200);
        query.append("SELECT ").append("player_id").append(" FROM ").append("block_table").append(" WHERE ").append("world").append("='").append(block.getWorldName()).append("' AND ").append("x").append("=").append(block.getX()).append(" AND ").append("y").append("=").append(block.getY()).append(" AND ").append("z").append("=").append(block.getZ()).append(";");
        return query.toString();
    }

    @Override
    protected String generateGetOwnerQuery(OwnedEntity entity) {
        StringBuilder query = new StringBuilder(200);
        query.append("SELECT ").append("player_id").append(" FROM ").append("entity_table").append(" WHERE ").append("world").append("='").append(entity.getWorldName()).append("' AND ").append("entity_id").append("='").append(entity.getUniqueId().toString()).append("';");
        return query.toString();
    }

    @Override
    protected String generateSetBlockOwnerQuery(DatabaseAction databaseAction) {
        OwnedBlock block = (OwnedBlock)databaseAction.getOwnable();
        String worldName = databaseAction.getOwnable().getWorldName();
        String playerId = databaseAction.getUser().getId().toString();
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        StringBuilder query = new StringBuilder(200);
        query.append("INSERT OR REPLACE INTO ").append("block_table").append("(").append("world").append(", ").append("x").append(", ").append("y").append(", ").append("z").append(", ").append("player_id").append(") VALUES('").append(worldName).append("', '").append(x).append("', '").append(y).append("', '").append(z).append("', '").append(playerId).append("');");
        return query.toString();
    }

    @Override
    protected String generateSetEntityOwnerQuery(DatabaseAction databaseAction) {
        OwnedEntity entity = (OwnedEntity)databaseAction.getOwnable();
        String worldName = databaseAction.getOwnable().getWorldName();
        String playerId = databaseAction.getUser().getId().toString();
        UUID entityId = entity.getUniqueId();
        StringBuilder query = new StringBuilder(200);
        query.append("INSERT OR REPLACE INTO ").append("entity_table").append("(").append("world").append(", ").append("entity_id").append(", ").append("player_id").append(") VALUES('").append(worldName).append("', '").append(entityId.toString()).append("', '").append(playerId).append("');");
        return query.toString();
    }

    @Override
    protected String generateDeleteOwnerQuery(OwnedEntity entity) {
        StringBuilder query = new StringBuilder(200);
        query.append("DELETE FROM ").append("entity_table").append(" WHERE ").append("world").append("='").append(entity.getWorldName()).append("' AND ").append("entity_id").append("='").append(entity.getUniqueId().toString()).append("';");
        return query.toString();
    }

    @Override
    protected String generateDeleteOwnerQuery(OwnedBlock block) {
        StringBuilder query = new StringBuilder(200);
        query.append("DELETE FROM ").append("block_table").append(" WHERE ").append("world").append("='").append(block.getWorldName()).append("' AND ").append("x").append("=").append(block.getX()).append(" AND ").append("y").append("=").append(block.getY()).append(" AND ").append("z").append("=").append(block.getZ()).append(";");
        return query.toString();
    }

    @Override
    protected String generateDropUserBlocksQuery(User user) {
        StringBuilder query = new StringBuilder(150);
        query.append("DELETE FROM ").append("block_table").append(" WHERE ").append("player_id").append("='").append(user.getId().toString()).append("';");
        return query.toString();
    }

    @Override
    protected String generateDropUserEntitiesQuery(User user) {
        StringBuilder query = new StringBuilder(150);
        query.append("DELETE FROM ").append("entity_table").append(" WHERE ").append("player_id").append("='").append(user.getId().toString()).append("';");
        return query.toString();
    }
}

