/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import de.pheasn.blockown.Output;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.ActionNotPerformedException;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;
import de.pheasn.blockown.database.UnknownOwnableException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class Database
implements Runnable {
    protected static final String PLAYER_ID_COLUMN = "player_id";
    protected static final String WORLD_COLUMN = "world";
    protected static final String ENTITY_ID_COLUMN = "entity_id";
    protected static final String X_COLUMN = "x";
    protected static final String Y_COLUMN = "y";
    protected static final String Z_COLUMN = "z";
    protected static final String BLOCK_TABLE = "block_table";
    protected static final String ENTITY_TABLE = "entity_table";
    protected final ConcurrentLinkedQueue<DatabaseAction> queue;
    protected volatile boolean disable = false;
    protected final Object LOCK = new Object();
    protected final Output output;
    protected Connection connection;

    protected Database(Output output) {
        this.output = output;
        this.queue = new ConcurrentLinkedQueue();
    }

    protected Output getOutput() {
        return this.output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueue(DatabaseAction databaseAction) {
        Object object = this.LOCK;
        synchronized (object) {
            this.queue.add(databaseAction);
            this.LOCK.notifyAll();
        }
    }

    public User getOwner(Ownable ownable) {
        return this.getDatabaseOwner(ownable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void disable() {
        Object object = this.LOCK;
        synchronized (object) {
            this.disable = true;
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.disable || !this.queue.isEmpty()) {
            if (!this.queue.isEmpty()) {
                DatabaseAction databaseAction = (DatabaseAction)this.queue.remove();
                if (databaseAction.getActionType() == DatabaseActionType.DROP) {
                    this.dropDatabaseUserData(databaseAction.getUser());
                    continue;
                }
                if (this.setDatabaseOwner(databaseAction)) continue;
                this.getOutput().printException("An action has not been performed", new ActionNotPerformedException(databaseAction));
                continue;
            }
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    while (!this.disable && this.queue.isEmpty()) {
                        this.LOCK.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                this.getOutput().printException("Database thread has been interrupted.", e);
            }
        }
        this.close();
    }

    protected User getDatabaseOwner(Ownable ownable) {
        try {
            Statement stmnt = this.connection.createStatement();
            String query = null;
            if (ownable instanceof OwnedBlock) {
                query = this.generateGetOwnerQuery((OwnedBlock)ownable);
            } else if (ownable instanceof OwnedEntity) {
                query = this.generateGetOwnerQuery((OwnedEntity)ownable);
            } else {
                this.getOutput().printException(new UnknownOwnableException());
                stmnt.close();
                return null;
            }
            ResultSet rs = stmnt.executeQuery(query);
            if (rs.next()) {
                User owner = new User(UUID.fromString(rs.getString(PLAYER_ID_COLUMN)));
                stmnt.close();
                return owner;
            }
            stmnt.close();
            return User.nobody;
        }
        catch (SQLException e) {
            this.getOutput().printException(e);
            return null;
        }
    }

    protected boolean setDatabaseOwner(DatabaseAction databaseAction) {
        try {
            Statement stmnt = this.connection.createStatement();
            if (databaseAction.getActionType() == DatabaseActionType.UNOWN || databaseAction.getUser() == null || databaseAction.getUser().isNobody()) {
                String query = null;
                if (databaseAction.getOwnable() instanceof OwnedBlock) {
                    query = this.generateDeleteOwnerQuery((OwnedBlock)databaseAction.getOwnable());
                } else if (databaseAction.getOwnable() instanceof OwnedEntity) {
                    query = this.generateDeleteOwnerQuery((OwnedEntity)databaseAction.getOwnable());
                } else {
                    this.getOutput().printException(new UnknownOwnableException());
                    stmnt.close();
                    return false;
                }
                stmnt.executeUpdate(query);
                stmnt.close();
                return true;
            }
            if (databaseAction.getActionType() == DatabaseActionType.OWN) {
                String query = null;
                if (databaseAction.getOwnable() instanceof OwnedBlock) {
                    query = this.generateSetBlockOwnerQuery(databaseAction);
                } else if (databaseAction.getOwnable() instanceof OwnedEntity) {
                    query = this.generateSetEntityOwnerQuery(databaseAction);
                } else {
                    this.getOutput().printException(new UnknownOwnableException());
                    stmnt.close();
                    return false;
                }
                stmnt.executeUpdate(query);
                stmnt.close();
                return true;
            }
            this.getOutput().printException(new IllegalArgumentException());
            stmnt.close();
            return false;
        }
        catch (SQLException e) {
            this.getOutput().printException(e);
            return false;
        }
    }

    protected void dropDatabaseUserData(User user) {
        if (user.isNobody()) {
            return;
        }
        try {
            Statement stmnt = this.connection.createStatement();
            String query = null;
            query = this.generateDropUserBlocksQuery(user);
            stmnt.executeUpdate(query);
            query = this.generateDropUserEntitiesQuery(user);
            stmnt.executeUpdate(query);
            stmnt.close();
        }
        catch (SQLException e) {
            this.getOutput().printException(e);
            return;
        }
    }

    protected boolean flushDatabase(Map<Ownable, User> cacheData) {
        for (Map.Entry<Ownable, User> owning : cacheData.entrySet()) {
            if (!(owning.getValue().isNobody() ? !this.setDatabaseOwner(new DatabaseAction(DatabaseActionType.UNOWN, owning.getKey(), null)) : !this.setDatabaseOwner(new DatabaseAction(DatabaseActionType.OWN, owning.getKey(), owning.getValue())))) continue;
            return false;
        }
        return true;
    }

    protected void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            this.getOutput().printException("Couldn't close database connection", e);
        }
    }

    protected abstract String generateCreateEntityTableQuery();

    protected abstract String generateCreateBlockTableQuery();

    protected abstract String generateGetOwnerQuery(OwnedBlock var1);

    protected abstract String generateGetOwnerQuery(OwnedEntity var1);

    protected abstract String generateSetBlockOwnerQuery(DatabaseAction var1);

    protected abstract String generateSetEntityOwnerQuery(DatabaseAction var1);

    protected abstract String generateDeleteOwnerQuery(OwnedEntity var1);

    protected abstract String generateDeleteOwnerQuery(OwnedBlock var1);

    protected abstract String generateDropUserBlocksQuery(User var1);

    protected abstract String generateDropUserEntitiesQuery(User var1);
}

