/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import de.pheasn.blockown.Output;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.ActionNotPerformedException;
import de.pheasn.blockown.database.Cache;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.DatabaseAction;
import java.io.File;

public abstract class CachedDatabase
extends Database {
    private final Cache cache;

    protected CachedDatabase(Output output, File pluginFolder) {
        super(output);
        this.cache = new Cache(this, pluginFolder);
    }

    @Override
    public User getOwner(Ownable ownable) {
        return this.cache.getOwner(ownable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.disable || !this.queue.isEmpty()) {
            if (!this.queue.isEmpty()) {
                DatabaseAction databaseAction = (DatabaseAction)this.queue.remove();
                if (this.cache.doAction(databaseAction)) continue;
                this.getOutput().printException(new ActionNotPerformedException(databaseAction));
                continue;
            }
            this.cache.flush();
            if (this.disable || !this.queue.isEmpty()) continue;
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    while (!this.disable && this.queue.isEmpty()) {
                        this.LOCK.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                this.getOutput().printException("Database thread has been interrupted.", e);
            }
        }
        this.cache.flush();
        this.close();
    }
}

