/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.CachedDatabase;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bukkit.Bukkit;

public class Cache {
    private static final int BLOCKS_PER_PLAYER = 131072;
    private static final int DEFAULT_START_CAPACITY = 0x100000;
    private final File dumpFile;
    private final CachedDatabase database;
    private final Map<Ownable, User> cache;
    private final Map<Ownable, User> unsubmitted;

    Cache(CachedDatabase database, File pluginFolder) {
        this.database = database;
        this.dumpFile = new File(pluginFolder.getAbsoluteFile(), "dumpFile.dat");
        if (this.dumpFile.exists()) {
            this.unsubmitted = this.restoreDumpedCache();
            this.cache = this.initializeCache();
            this.cache.putAll(this.unsubmitted);
        } else {
            this.unsubmitted = this.initializeCache();
            this.cache = this.initializeCache();
        }
    }

    private Map<Ownable, User> initializeCache() {
        int initialCapacity;
        try {
            initialCapacity = Bukkit.getOfflinePlayers().length * 131072;
        }
        catch (NullPointerException e) {
            initialCapacity = 0;
        }
        if (initialCapacity == 0) {
            initialCapacity = 0x100000;
        }
        return new HashMap<Ownable, User>(initialCapacity);
    }

    private Map<Ownable, User> restoreDumpedCache() {
        Map result = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.dumpFile));
            Object o = ois.readObject();
            ois.close();
            if (o instanceof Map) {
                assert (((Map)o).keySet().iterator().next() instanceof Ownable);
                assert (((Map)o).values().iterator().next() instanceof User);
                result = (Map)o;
            }
            this.dumpFile.delete();
        }
        catch (FileNotFoundException e) {
            this.database.getOutput().printException("Error restoring dumped cache.", e);
        }
        catch (IOException e) {
            this.database.getOutput().printException("Error restoring dumped cache.", e);
        }
        catch (ClassNotFoundException e) {
            this.database.getOutput().printException("Error restoring dumped cache.", e);
        }
        return result == null ? this.initializeCache() : result;
    }

    User getOwner(Ownable ownable) {
        User owner = this.cache.get(ownable);
        if (owner == null) {
            owner = this.database.getDatabaseOwner(ownable);
            this.cache.put(ownable, owner);
        }
        return owner;
    }

    boolean doAction(DatabaseAction databaseAction) {
        if (databaseAction.getActionType() == DatabaseActionType.UNOWN || databaseAction.getUser() == null || databaseAction.getUser().isNobody()) {
            this.cache.put(databaseAction.getOwnable(), User.nobody);
            this.unsubmitted.put(databaseAction.getOwnable(), User.nobody);
            return true;
        }
        if (databaseAction.getActionType() == DatabaseActionType.OWN) {
            this.cache.put(databaseAction.getOwnable(), databaseAction.getUser());
            this.unsubmitted.put(databaseAction.getOwnable(), databaseAction.getUser());
            return true;
        }
        if (databaseAction.getActionType() == DatabaseActionType.DROP) {
            this.dropUserData(databaseAction.getUser());
            return true;
        }
        this.database.getOutput().printException(new IllegalArgumentException());
        return false;
    }

    void flush() {
        if (!this.database.flushDatabase(this.unsubmitted)) {
            try {
                this.dumpFile.createNewFile();
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.dumpFile, false));
                oos.writeObject(this.unsubmitted);
                oos.close();
            }
            catch (IOException e) {
                this.database.getOutput().printException(e);
            }
            this.database.getOutput().printConsole("The cache has been dumped to the hard drive");
        } else {
            this.unsubmitted.clear();
        }
    }

    void dropUserData(User user) {
        Map.Entry<Ownable, User> entry;
        if (user == null) {
            return;
        }
        Iterator<Map.Entry<Ownable, User>> iterator = this.cache.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!user.equals(entry.getValue())) continue;
            iterator.remove();
        }
        iterator = this.unsubmitted.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (!user.equals(entry.getValue())) continue;
            iterator.remove();
        }
        this.database.dropDatabaseUserData(user);
    }
}

