/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.command;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.bukkit.Location;
import org.bukkit.block.Block;

class RegionIterator
implements Iterator<Block> {
    private final Location min;
    private final Location max;
    private Location position = null;

    public RegionIterator(Location min, Location max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean hasNext() {
        return this.min.getBlockX() != this.max.getBlockX() || this.min.getBlockY() != this.max.getBlockY() || this.min.getBlockZ() != this.max.getBlockZ();
    }

    @Override
    public Block next() {
        if (this.position == null) {
            this.position = this.min.clone();
        } else if (this.position.getBlockX() != this.max.getBlockX()) {
            this.position.add(1.0, 0.0, 0.0);
        } else {
            this.position.setX((double)this.min.getBlockX());
            if (this.position.getBlockY() != this.max.getBlockY()) {
                this.position.add(0.0, 1.0, 0.0);
            } else {
                this.position.setY((double)this.min.getBlockY());
                if (this.position.getBlockZ() != this.max.getBlockZ()) {
                    this.position.add(0.0, 0.0, 1.0);
                } else {
                    throw new NoSuchElementException();
                }
            }
        }
        return this.position.getBlock();
    }

    @Override
    public void remove() {
    }
}

