/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.command;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.command.CommandExecutor;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CE_ShowOwner
extends CommandExecutor {
    private static final String PARAM_ENTITY = "e";

    public CE_ShowOwner(BlockOwn plugin) {
        super(plugin);
    }

    @Override
    public boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
        if (!player.hasPermission(Permission.OWN_SHOWOWNER.toString())) {
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_PERMISSION);
            return true;
        }
        if (!this.plugin.isEnabledInWorld(player.getWorld())) {
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_DISABLED_IN_WORLD);
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase(PARAM_ENTITY)) {
            User user = new User(player.getUniqueId());
            if (this.plugin.isWaiting(user, WaitType.SHOW_OWNER)) {
                this.plugin.removeWaiting(user);
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
            } else {
                this.plugin.addWaiting(user, WaitType.SHOW_OWNER);
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_SHOWOWNER_CLICK_SOMEWHERE);
            }
            return true;
        }
        Block block = player.getTargetBlock(null, 20);
        if (block != null) {
            User owner = this.plugin.getOwningDatabase().getOwner(new OwnedBlock(block));
            if (owner.isNobody()) {
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_SHOWOWNER_BLOCK_UNOWNED);
            } else {
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_SHOWOWNER_BLOCK_FOUND, owner.getName());
            }
            return true;
        }
        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NOTARGET);
        return false;
    }
}

