/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.command;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.Selection;
import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.command.CommandExecutor;
import de.pheasn.blockown.command.RegionIterator;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CE_Own
extends CommandExecutor {
    private static final String PARAM_SELECTION = "selection";
    private static final String PARAM_ENTITY = "e";
    private final WorldEditPlugin worldEdit;

    public CE_Own(BlockOwn plugin) {
        super(plugin);
        this.worldEdit = (WorldEditPlugin)plugin.getServer().getPluginManager().getPlugin("WorldEdit");
    }

    @Override
    protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
        if (!player.hasPermission(Permission.OWN_OWN.toString())) {
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_PERMISSION);
            return true;
        }
        if (!this.plugin.isEnabledInWorld(player.getWorld())) {
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_DISABLED_IN_WORLD);
            return true;
        }
        User user = new User(player.getUniqueId());
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase(PARAM_SELECTION)) {
                if (!player.hasPermission(Permission.OWN_OWNSELECTION.toString())) {
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_PERMISSION);
                    return true;
                }
            } else {
                if (args[0].equalsIgnoreCase(PARAM_ENTITY)) {
                    if (this.plugin.isWaiting(user, WaitType.OWN)) {
                        this.plugin.removeWaiting(user);
                        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                    } else {
                        this.plugin.addWaiting(user, WaitType.OWN);
                        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_OWN_CLICK_SOMEWHERE);
                    }
                    return true;
                }
                return false;
            }
            if (this.worldEdit != null) {
                Selection selection = this.worldEdit.getSelection(player);
                Location min = selection.getMinimumPoint();
                Location max = selection.getMaximumPoint();
                RegionIterator region = new RegionIterator(min, max);
                int ownedCounter = 0;
                while (region.hasNext()) {
                    Block bukkitBlock = region.next();
                    OwnedBlock block = new OwnedBlock(bukkitBlock);
                    if (bukkitBlock.getType() == Material.AIR || !this.plugin.isOwnEnabled(block.getMaterial()) || !this.plugin.getOwningDatabase().getOwner(block).isNobody()) continue;
                    DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, block, user);
                    this.plugin.getOwningDatabase().enqueue(databaseAction);
                    ++ownedCounter;
                }
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_OWN_SELECTION_SUCCESS, ownedCounter);
                return true;
            }
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_OWN_SELECTION_NOWORLDEDIT);
            return true;
        }
        if (args.length == 0) {
            Block targetBlock = player.getTargetBlock(null, 20);
            if (targetBlock != null) {
                OwnedBlock block = new OwnedBlock(targetBlock);
                if (this.plugin.isOwnEnabled(block.getMaterial())) {
                    User owner = this.plugin.getOwningDatabase().getOwner(block);
                    if (owner.isNobody()) {
                        DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, block, user);
                        this.plugin.getOwningDatabase().enqueue(databaseAction);
                        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_OWN_BLOCKSUCCESS, block.getMaterial().getName());
                        return true;
                    }
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_OWN_NOPERMISSIONFOROTHERS, owner.getName());
                }
                return false;
            }
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NOTARGET);
            return false;
        }
        return false;
    }
}

