/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Material;
import de.pheasn.blockown.Ownable;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class User
implements Serializable {
    private static final long serialVersionUID = -9170381319637300740L;
    public static final User nobody = new User(null);
    private static BlockOwn plugin = null;
    private final UUID id;
    private transient WeakReference<OfflinePlayer> player;

    public User(UUID id) {
        this.id = id;
    }

    public User(UUID id, OfflinePlayer player) {
        this.id = id;
        this.player = new WeakReference<OfflinePlayer>(player);
    }

    static synchronized void initialize(BlockOwn plugin) {
        User.plugin = plugin;
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isOnline() {
        OfflinePlayer o = this.getOfflinePlayer();
        return o == null ? false : o.isOnline();
    }

    public boolean isOp() {
        OfflinePlayer o = this.getOfflinePlayer();
        return o == null ? false : o.isOp();
    }

    public String getName() {
        OfflinePlayer o = this.getOfflinePlayer();
        return o == null ? null : o.getName();
    }

    public OfflinePlayer getOfflinePlayer() {
        try {
            if (this.isNobody()) {
                return null;
            }
            if (this.player == null || this.player.get() == null) {
                this.player = new WeakReference<OfflinePlayer>(this.getPlugin().getServer().getOfflinePlayer(this.id));
            }
            return (OfflinePlayer)this.player.get();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public World getWorld() {
        OfflinePlayer offlinePlayer = this.getOfflinePlayer();
        if (offlinePlayer == null) {
            return null;
        }
        Player player = offlinePlayer.getPlayer();
        if (player == null) {
            return null;
        }
        return player.getWorld();
    }

    public boolean isNobody() {
        return this.id == null;
    }

    private BlockOwn getPlugin() {
        if (plugin == null) {
            User.initialize((BlockOwn)Bukkit.getPluginManager().getPlugin("BlockOwn"));
        }
        return plugin;
    }

    public boolean hasAccess(Ownable ownable) {
        User owner = this.getPlugin().getOwningDatabase().getOwner(ownable);
        if (owner == null) {
            return true;
        }
        return this.hasAccess(ownable.getMaterial(), owner);
    }

    public boolean hasAccess(Material material, User owner) {
        return this.getPlugin().getProtection().hasAccess(owner, material, this);
    }

    public boolean hasProtected(Material material) {
        return this.getPlugin().getProtection().isProtected(this, material);
    }

    public boolean hasLocked(Material material) {
        return this.getPlugin().getProtection().isLocked(this, material);
    }

    public boolean hasFriend(User user) {
        return this.getPlugin().getProtection().isFriend(this, user);
    }

    public int hashCode() {
        int prime = 19;
        int result = 199;
        result = 19 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        String name = this.getName();
        return name == null ? "nobody" : name;
    }
}

