/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.Output;
import de.pheasn.pluginupdater.ReleaseChannel;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class Setting<T> {
    public static final Setting<String> VERSION = new Setting("version");
    public static final Setting<Boolean> DEBUG_MODE = new Setting("debug-mode");
    public static final Setting<List<String>> ENABLED_WORLDS = new Setting("enabledWorlds");
    public static final Setting<List<String>> DISABLED_WORLDS = new Setting("disabledWorlds");
    public static final Setting<Boolean> UPDATER_ENABLE = new Setting("Updater.enable");
    public static final Setting<String> UPDATER_RELEASE_CHANNEL = new Setting("Updater.release-channel");
    public static final Setting<String> UPDATER_API_KEY = new Setting("Updater.apiKey");
    public static final Setting<Boolean> DATABASE_MYSQL_ENABLE = new Setting("Database.MySQL.enable");
    public static final Setting<String> DATABASE_MYSQL_HOST = new Setting("Database.MySQL.host");
    public static final Setting<Integer> DATABASE_MYSQL_PORT = new Setting("Database.MySQL.port");
    public static final Setting<String> DATABASE_MYSQL_DATABASE = new Setting("Database.MySQL.database");
    public static final Setting<String> DATABASE_MYSQL_USER = new Setting("Database.MySQL.user");
    public static final Setting<String> DATABASE_MYSQL_PASSWORD = new Setting("Database.MySQL.password");
    public static final Setting<Boolean> DATABASE_ALLOW_ENTITIES = new Setting("Database.allowEntities");
    public static final Setting<Boolean> DATABASE_ALLOW_ANIMALS = new Setting("Database.allowAnimals");
    public static final Setting<List<String>> DATABASE_ALLOWED_MATERIALS = new Setting("Database.allowedMaterials");
    public static final Setting<List<String>> DATABASE_DISALLOWED_MATERIALS = new Setting("Database.disallowedMaterials");
    public static final Setting<Boolean> PROTECTION_AUTO_PROTECT_OWNED_BLOCKS = new Setting("Protection.autoProtectOwnedBlocks");
    public static final Setting<Boolean> PROTECTION_AUTO_PROTECT_OWNED_ENTITIES = new Setting("Protection.autoProtectOwnedEntities");
    public static final Setting<Boolean> PROTECTION_AUTO_PROTECT_OWNED_ANIMALS = new Setting("Protection.autoProtectOwnedAnimals");
    public static final Setting<List<String>> PROTECTION_AUTO_PROTECT_MATERIALS = new Setting("Protection.autoProtectMaterials");
    public static final Setting<List<String>> PROTECTION_ALLOWED_MATERIALS = new Setting("Protection.allowedMaterials");
    public static final Setting<List<String>> PROTECTION_DISALLOWED_MATERIALS = new Setting("Protection.disallowedMaterials");
    public static final Setting<Boolean> PROTECTION_PROTECT_AGAINST_ENVIRONMENT = new Setting("Protection.protectAgainstEnvironment");
    public static final Setting<Boolean> PROTECTION_ALLOW_RIGHT_CLICKS = new Setting("Protection.allowRightClicks");
    private static Output output;
    private static FileConfiguration config;
    private final String path;

    public static void setOutput(Output output) {
        Setting.output = output;
    }

    public static void setConfig(FileConfiguration config) {
        Setting.config = config;
    }

    private static Output getOutput() {
        return output;
    }

    private static FileConfiguration getConfig() {
        return config;
    }

    private Setting(String path) {
        this.path = path;
    }

    public T get() {
        try {
            Object o = Setting.getConfig().get(this.path);
            if (o == null) {
                return null;
            }
            Object t = o;
            return (T)t;
        }
        catch (ClassCastException e) {
            if (Setting.getOutput() != null) {
                Setting.getOutput().printException("Setting wasn't available in correct type", e);
            } else {
                System.out.println("Setting wasn't available in correct type");
            }
            return null;
        }
    }

    public ReleaseChannel getReleaseChannel() {
        try {
            return ReleaseChannel.valueOf(Setting.getConfig().getString(this.path).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            Setting.getOutput().printException(e);
            return null;
        }
    }

    public void set(Object value) {
        Setting.getConfig().set(this.path, value);
    }

    public String toString() {
        return this.path;
    }

    @Deprecated
    public static enum OLD {
        PROTECTION_PROTECT_ONLY_LEFT_CLICKS("3.0.5", new Setting<T>("Protection.onlyLeftClicks"), new Runnable(){

            @Override
            public void run() {
                PROTECTION_ALLOW_RIGHT_CLICKS.set(PROTECTION_PROTECT_ONLY_LEFT_CLICKS.getSetting().get());
            }
        });

        private final String deprecatingVersion;
        private final Setting<?> setting;
        private final Runnable transfer;

        private OLD(String deprecatingVersion, Setting<?> setting, Runnable transfer) {
            this.deprecatingVersion = deprecatingVersion;
            this.setting = setting;
            this.transfer = transfer;
        }

        public Setting<?> getSetting() {
            return this.setting;
        }

        public String getDeprecatingVersion() {
            return this.deprecatingVersion;
        }

        public void transferValue() {
            this.transfer.run();
        }
    }
}

