/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.Material;
import de.pheasn.blockown.Ownable;
import java.lang.ref.WeakReference;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class OwnedEntity
implements Ownable {
    private static final long serialVersionUID = -5197934920645104143L;
    private transient WeakReference<Entity> entityRef;
    private final UUID id;
    private final String worldName;
    private transient Material material;

    public OwnedEntity(Entity entity) {
        this.worldName = entity.getWorld().getName();
        this.id = entity.getUniqueId();
        this.entityRef = new WeakReference<Entity>(entity);
        this.material = new Material(entity.getType());
    }

    public OwnedEntity(UUID id, String worldName, EntityType entityType) {
        this.id = id;
        this.worldName = worldName;
        this.material = new Material(entityType);
    }

    public OwnedEntity(UUID id, String worldName) {
        this.id = id;
        this.worldName = worldName;
        this.material = null;
    }

    public Entity getEntity() {
        Entity result;
        Entity entity = result = this.entityRef == null ? null : (Entity)this.entityRef.get();
        if (result == null) {
            for (Entity entity2 : this.getWorld().getEntitiesByClass(this.material.getEntityType().getEntityClass())) {
                if (!entity2.getUniqueId().equals(this.id)) continue;
                this.entityRef = new WeakReference<Entity>(entity2);
                return entity2;
            }
            return null;
        }
        return result;
    }

    public UUID getUniqueId() {
        return this.id;
    }

    @Override
    public World getWorld() {
        return Bukkit.getServer().getWorld(this.worldName);
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public Material getMaterial() {
        if (this.material == null) {
            try {
                for (Entity entity : Bukkit.getWorld((String)this.worldName).getEntities()) {
                    if (!entity.getUniqueId().equals(this.id)) continue;
                    this.material = new Material(entity.getType());
                    break;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.material;
    }

    public boolean isLiving() {
        return this.getEntity() instanceof LivingEntity;
    }

    public int hashCode() {
        int prime = 61;
        int result = 2131;
        result = 61 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OwnedEntity other = (OwnedEntity)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "OwnedEntity [id=" + this.id + ", worldName=" + this.worldName + ", material=" + this.material + "]";
    }
}

