/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.Material;
import de.pheasn.blockown.Ownable;
import java.lang.ref.WeakReference;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;

public class OwnedBlock
implements Ownable {
    private static final long serialVersionUID = 4996349639615230112L;
    private transient WeakReference<Block> blockRef;
    private final String worldName;
    private final int x;
    private final int y;
    private final int z;
    private transient Material material;

    public OwnedBlock(Block block) {
        World world = block.getWorld();
        this.worldName = world.getName();
        this.x = block.getX();
        this.y = block.getY();
        this.z = block.getZ();
        this.material = new Material(block.getType());
        this.blockRef = new WeakReference<Block>(block);
    }

    public OwnedBlock(String worldName, int x, int y, int z, Material material) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.material = material;
    }

    public OwnedBlock(String worldName, int x, int y, int z) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.material = null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    @Override
    public World getWorld() {
        return Bukkit.getServer().getWorld(this.worldName);
    }

    public Block getBlock() {
        Block result;
        Block block = result = this.blockRef == null ? null : (Block)this.blockRef.get();
        if (result == null) {
            result = this.getWorld().getBlockAt(this.x, this.y, this.z);
            this.blockRef = new WeakReference<Block>(result);
        }
        return result;
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public Material getMaterial() {
        if (this.material == null) {
            try {
                this.material = new Material(Bukkit.getServer().getWorld(this.worldName).getBlockAt(this.x, this.y, this.z).getType());
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.material;
    }

    public int hashCode() {
        int prime = 41;
        int result = 1733;
        result = 41 * result + (this.worldName == null ? 0 : this.worldName.hashCode());
        result = 41 * result + this.x;
        result = 41 * result + this.y;
        result = 41 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OwnedBlock other = (OwnedBlock)obj;
        if (this.worldName == null ? other.worldName != null : !this.worldName.equals(other.worldName)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return "OwnedBlock [block=" + this.getWorldName() + ":" + this.getX() + "," + this.getY() + "," + this.getZ() + "]";
    }
}

