/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.BlockOwn;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Message {
    private static final ChatColor COLOR_ERROR = ChatColor.RED;
    private static final ChatColor COLOR_WARNING = ChatColor.YELLOW;
    private static final ChatColor COLOR_INFO = ChatColor.WHITE;
    private static final ChatColor COLOR_SUCCESS = ChatColor.GREEN;
    public static final Message UPDATER_RESTART = new Message("Updater.restart", COLOR_WARNING);
    public static final Message UPDATER_DOWNLOADING = new Message("Updater.downloading", COLOR_INFO);
    public static final Message UPDATER_BIG_UPDATE = new Message("Updater.bigUpdate", COLOR_WARNING);
    public static final Message COMMAND_PLAYERS_ONLY = new Message("Command.justForPlayers", COLOR_ERROR);
    public static final Message COMMAND_CONSOLE_ONLY = new Message("Command.justForConsole", COLOR_ERROR);
    public static final Message COMMAND_NO_PERMISSION = new Message("Command.noPermission", COLOR_ERROR);
    public static final Message COMMAND_INVALID_PLAYER = new Message("Command.invalidPlayer", COLOR_ERROR);
    public static final Message COMMAND_INVALID_MATERIAL = new Message("Command.invalidMaterial", COLOR_ERROR);
    public static final Message COMMAND_NOTARGET = new Message("Command.noTarget", COLOR_ERROR);
    public static final Message COMMAND_DISABLED_IN_WORLD = new Message("Command.disabledInWorld", COLOR_ERROR);
    public static final Message COMMAND_NO_MORE_CLICK_WAITING = new Message("Command.noMoreClickWaiting", COLOR_INFO);
    public static final Message COMMAND_IGNORE_SUCCESS = new Message("Command.Ignore.success", COLOR_SUCCESS);
    public static final Message COMMAND_IMPORT_START = new Message("Command.Import.start", COLOR_INFO);
    public static final Message COMMAND_IMPORT_SUCCESS = new Message("Command.Import.success", COLOR_SUCCESS);
    public static final Message COMMAND_SHOWOWNER_CLICK_SOMEWHERE = new Message("Command.Showowner.clickOnEntity", COLOR_SUCCESS);
    public static final Message COMMAND_SHOWOWNER_ENTITY_UNOWNED = new Message("Command.Showowner.entityUnowned", COLOR_SUCCESS);
    public static final Message COMMAND_SHOWOWNER_ENTITY_FOUND = new Message("Command.Showowner.entityOwned", COLOR_SUCCESS);
    public static final Message COMMAND_SHOWOWNER_BLOCK_UNOWNED = new Message("Command.Showowner.blockUnowned", COLOR_SUCCESS);
    public static final Message COMMAND_SHOWOWNER_BLOCK_FOUND = new Message("Command.Showowner.blockOwned", COLOR_SUCCESS);
    public static final Message COMMAND_OWN_BLOCKSUCCESS = new Message("Command.Own.blockSuccess", COLOR_SUCCESS);
    public static final Message COMMAND_OWN_CLICK_SOMEWHERE = new Message("Command.Own.clickOnEntity", COLOR_SUCCESS);
    public static final Message COMMAND_OWN_ENTITYSUCCESS = new Message("Command.Own.entitySuccess", COLOR_SUCCESS);
    public static final Message COMMAND_OWN_NOPERMISSIONFOROTHERS = new Message("Command.Own.noPermissionForOthers", COLOR_ERROR);
    public static final Message COMMAND_OWN_SELECTION_SUCCESS = new Message("Command.Own.Selection.success", COLOR_SUCCESS);
    public static final Message COMMAND_OWN_SELECTION_NOWORLDEDIT = new Message("Command.Own.Selection.noWorldEdit", COLOR_ERROR);
    public static final Message COMMAND_UNOWN_BLOCKSUCCESS = new Message("Command.Unown.blockSuccess", COLOR_SUCCESS);
    public static final Message COMMAND_UNOWN_CLICK_SOMEWHERE = new Message("Command.Unown.clickOnEntity", COLOR_SUCCESS);
    public static final Message COMMAND_UNOWN_ENTITYSUCCESS = new Message("Command.Unown.entitySuccess", COLOR_SUCCESS);
    public static final Message COMMAND_UNOWN_FOROTHERS_NOTALLOWED = new Message("Command.Unown.noPermissionForOthers", COLOR_ERROR);
    public static final Message COMMAND_UNOWN_SELECTION_SUCCESS = new Message("Command.Unown.Selection.success", COLOR_SUCCESS);
    public static final Message COMMAND_UNOWN_SELECTION_NOWORLDEDIT = new Message("Command.Unown.Selection.noWorldEdit", COLOR_ERROR);
    public static final Message COMMAND_ADDFRIEND_SUCCESS = new Message("Command.Addfriend.success", COLOR_SUCCESS);
    public static final Message COMMAND_REMFRIEND_SUCCESS = new Message("Command.Remfriend.success", COLOR_SUCCESS);
    public static final Message COMMAND_LOCK_SUCCESS = new Message("Command.Lock.success", COLOR_SUCCESS);
    public static final Message COMMAND_LOCK_CLICK_SOMEWHERE = new Message("Command.Lock.clickOnEntity", COLOR_SUCCESS);
    public static final Message COMMAND_UNLOCK_SUCCESS = new Message("Command.Unlock.success", COLOR_SUCCESS);
    public static final Message COMMAND_UNLOCK_CLICK_SOMEWHERE = new Message("Command.Unlock.clickOnEntity", COLOR_SUCCESS);
    public static final Message COMMAND_PROTECT_SUCCESS = new Message("Command.Protect.success", COLOR_SUCCESS);
    public static final Message COMMAND_PROTECT_CLICK_SOMEWHERE = new Message("Command.Protect.clickOnEntity", COLOR_SUCCESS);
    public static final Message COMMAND_UNPROTECT_SUCCESS = new Message("Command.Unprotect.success", COLOR_SUCCESS);
    public static final Message COMMAND_UNPROTECT_CLICK_SOMEWHERE = new Message("Command.Unprotect.clickOnEntity", COLOR_SUCCESS);
    public static final Message COMMAND_LIST_FRIENDS = new Message("Command.List.friendsMessageHead", COLOR_SUCCESS);
    public static final Message COMMAND_LIST_PROTECTED = new Message("Command.List.protectedMessageHead", COLOR_SUCCESS);
    public static final Message COMMAND_LIST_LOCKED = new Message("Command.List.lockedMessageHead", COLOR_SUCCESS);
    public static final Message COMMAND_LIST_EMPTY = new Message("Command.List.empty", COLOR_WARNING);
    public static final Message COMMAND_UNPROTECTPLAYER_SUCCESS = new Message("Command.Unprotectplayer.success", COLOR_SUCCESS);
    public static final Message COMMAND_UNOWNPLAYER_SUCCESS = new Message("Command.Unownplayer.success", COLOR_SUCCESS);
    private static FileConfiguration messages = null;
    private final String path;
    private final ChatColor chatColor;

    private Message(String path, ChatColor chatColor) {
        this.path = path;
        this.chatColor = chatColor;
    }

    static synchronized boolean loadMessages(BlockOwn plugin) {
        if (messages == null) {
            messages = YamlConfiguration.loadConfiguration((File)plugin.getMessageFile());
            try {
                messages.addDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(plugin.getResource("messages.yml"), "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                plugin.getOutput().printException("Error loading default messages", e);
                return false;
            }
            messages.options().copyDefaults(true);
            try {
                messages.save(plugin.getMessageFile());
                return true;
            }
            catch (IOException e) {
                plugin.getOutput().printException("Error saving message file", e);
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.chatColor + messages.getString(this.path);
    }
}

