/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import java.io.Serializable;
import org.bukkit.entity.EntityType;
import org.bukkit.material.MaterialData;

public class Material
implements Serializable {
    private static final long serialVersionUID = -3658668250059098095L;
    public static final String ANY_STRING = "ALL";
    public static final Material ANY = new Material(true);
    private final boolean isBlock;
    private final EntityType entityType;
    private final org.bukkit.Material material;

    private Material(boolean isBlock) {
        this.isBlock = isBlock;
        this.entityType = null;
        this.material = null;
    }

    public Material(org.bukkit.Material material) {
        this.isBlock = true;
        this.material = material;
        this.entityType = null;
    }

    public Material(EntityType entityType) {
        this.isBlock = false;
        this.material = null;
        this.entityType = entityType;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public org.bukkit.Material getMaterial() {
        return this.material;
    }

    public Class<? extends MaterialData> getData() {
        return this.material.getData();
    }

    public boolean isAny() {
        return this.material == null && this.entityType == null;
    }

    public boolean isBlock() {
        return this.isBlock;
    }

    public String getName() {
        if (this.isAny()) {
            return ANY_STRING;
        }
        if (this.isBlock()) {
            return this.material.toString();
        }
        return this.entityType.toString();
    }

    public static Material parseMaterial(String materialName) {
        org.bukkit.Material m;
        if (materialName.equalsIgnoreCase(ANY_STRING)) {
            return ANY;
        }
        EntityType t = null;
        try {
            t = EntityType.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (t != null) {
            return new Material(t);
        }
        try {
            int id = Integer.parseInt(materialName);
            m = org.bukkit.Material.getMaterial((int)id);
        }
        catch (NumberFormatException e) {
            m = org.bukkit.Material.matchMaterial((String)materialName);
        }
        if (m != null) {
            return new Material(m);
        }
        throw new IllegalArgumentException();
    }

    public int hashCode() {
        int prime = 59;
        int result = 1;
        result = 59 * result + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = 59 * result + (this.isBlock ? 1231 : 1237);
        result = 59 * result + (this.material == null ? 0 : this.material.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Material other = (Material)obj;
        if (this.isBlock != other.isBlock) {
            return false;
        }
        if (this.entityType != other.entityType) {
            return false;
        }
        return this.material == other.material;
    }

    public String toString() {
        return this.getName();
    }
}

