/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.Command;
import de.pheasn.blockown.DebugOutput;
import de.pheasn.blockown.DefaultOutput;
import de.pheasn.blockown.Material;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.Output;
import de.pheasn.blockown.Setting;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.command.CE_AddFriend;
import de.pheasn.blockown.command.CE_Ignore;
import de.pheasn.blockown.command.CE_Import;
import de.pheasn.blockown.command.CE_List;
import de.pheasn.blockown.command.CE_Lock;
import de.pheasn.blockown.command.CE_Own;
import de.pheasn.blockown.command.CE_Protect;
import de.pheasn.blockown.command.CE_RemFriend;
import de.pheasn.blockown.command.CE_ShowOwner;
import de.pheasn.blockown.command.CE_Unlock;
import de.pheasn.blockown.command.CE_Unown;
import de.pheasn.blockown.command.CE_UnownPlayer;
import de.pheasn.blockown.command.CE_Unprotect;
import de.pheasn.blockown.command.CE_UnprotectPlayer;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.MySqlDatabase;
import de.pheasn.blockown.database.SqliteDatabase;
import de.pheasn.blockown.event.L_BlockBreak;
import de.pheasn.blockown.event.L_BlockPlace;
import de.pheasn.blockown.event.L_EnvironmentDamage;
import de.pheasn.blockown.event.L_PlayerInteractEvent;
import de.pheasn.blockown.protection.Protection;
import de.pheasn.pluginupdater.PluginVersion;
import de.pheasn.pluginupdater.ReleaseChannel;
import de.pheasn.pluginupdater.Updatable;
import de.pheasn.pluginupdater.Updater;
import de.pheasn.pluginupdater.UpdaterKey;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Animals;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.mcstats.Metrics;

public class BlockOwn
extends JavaPlugin
implements Updatable {
    private static final String DATA_FOLDER_PATH = "plugins" + File.separator + "BlockOwn";
    private static final int PLUGIN_ID = 62749;
    private static final ReleaseChannel releaseChannel = ReleaseChannel.BETA;
    private Output output;
    private Database database;
    private Thread databaseThread;
    private Protection protection;
    private Thread protectionThread;
    private Updater updater;
    private Set<String> enabledWorlds;
    private Set<Material> ownEnabledMaterials;
    private Set<Material> ownDisabledMaterials;
    private File messageFile;
    private File configFile;
    private File protectionFile;
    private File importerFolder;
    private Set<User> ignoringUsers;
    private Map<User, WaitType> waitingUsers;

    public void onDisable() {
        this.database.disable();
        this.protection.disable();
        while (this.databaseThread.isAlive() || this.protectionThread.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.saveConfig();
        super.onDisable();
    }

    public void onEnable() {
        super.onEnable();
        Setting.setConfig(this.getConfig());
        this.output = Setting.DEBUG_MODE.get() != false ? new DebugOutput() : new DefaultOutput();
        Setting.setOutput(this.output);
        User.initialize(this);
        this.messageFile = new File(this.getDataFolder(), "messages.yml");
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.protectionFile = new File(this.getDataFolder(), "protection.dat");
        this.importerFolder = new File("./plugins/BlockOwn/Importer");
        this.updateDeprecatedSettings();
        if (!this.createDataStructure()) {
            this.getOutput().printException("Error creating data structure.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!this.initializeDatabase()) {
            this.getOutput().printException("Couldn't connect to database.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (!this.initializeProtection()) {
            this.getOutput().printException("Couldn't initialize Protection.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.enabledWorlds = this.getEnabledWorlds();
        this.ownEnabledMaterials = this.getOwnEnabledMaterials();
        this.ownDisabledMaterials = this.getOwnDisabledMaterials();
        this.ignoringUsers = new HashSet<User>(this.getServer().getOfflinePlayers().length * 2);
        this.waitingUsers = new HashMap<User, WaitType>(this.getServer().getOfflinePlayers().length * 2);
        this.registerListeners();
        this.registerCommands();
        this.updater = new Updater(this, 1800000, 62749, this.getFile(), Setting.UPDATER_API_KEY.get(), Setting.UPDATER_RELEASE_CHANNEL.getReleaseChannel());
        this.updater.start();
        this.initializeMetrics();
        Setting.VERSION.set(this.getDescription(UpdaterKey.VERSION) + "-" + (Object)((Object)this.getReleaseChannel()));
    }

    private void updateDeprecatedSettings() {
        PluginVersion oldVersion = new PluginVersion(Setting.VERSION.get(), this.getReleaseChannel());
        for (Setting.OLD oldSetting : Setting.OLD.values()) {
            PluginVersion deprecatingVersion = new PluginVersion(oldSetting.getDeprecatingVersion(), this.getReleaseChannel());
            if (deprecatingVersion.compareTo(oldVersion) <= 0) continue;
            oldSetting.transferValue();
            oldSetting.getSetting().set(null);
        }
    }

    private void initializeMetrics() {
        try {
            Metrics metrics = new Metrics((Plugin)this);
            metrics.start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Set<String> getEnabledWorlds() {
        HashSet<String> result = new HashSet<String>(20);
        List<String> disabled = Setting.DISABLED_WORLDS.get();
        List<String> enabled = Setting.ENABLED_WORLDS.get();
        if (disabled.isEmpty() && enabled.isEmpty()) {
            for (World world : this.getServer().getWorlds()) {
                result.add(world.getName());
            }
            return result;
        }
        HashSet<String> disabledLower = new HashSet<String>(disabled.size());
        for (String s : disabled) {
            disabledLower.add(s.toLowerCase());
        }
        HashSet<String> enabledLower = new HashSet<String>(enabled.size());
        for (String s : enabled) {
            enabledLower.add(s.toLowerCase());
        }
        for (World world : this.getServer().getWorlds()) {
            if (disabledLower.contains(world.getName().toLowerCase()) || !enabledLower.isEmpty() && !enabledLower.contains(world.getName().toLowerCase())) continue;
            result.add(world.getName());
        }
        return result;
    }

    private Set<Material> getOwnEnabledMaterials() {
        List<String> enabled = Setting.DATABASE_ALLOWED_MATERIALS.get();
        HashSet<Material> result = new HashSet<Material>(enabled.size(), 1.0f);
        for (String materialName : enabled) {
            try {
                Material m = Material.parseMaterial(materialName);
                result.add(m);
            }
            catch (IllegalArgumentException e) {}
        }
        return result;
    }

    private Set<Material> getOwnDisabledMaterials() {
        List<String> disabled = Setting.DATABASE_DISALLOWED_MATERIALS.get();
        HashSet<Material> result = new HashSet<Material>(disabled.size(), 1.0f);
        for (String materialName : disabled) {
            try {
                Material m = Material.parseMaterial(materialName);
                result.add(m);
            }
            catch (IllegalArgumentException e) {}
        }
        return result;
    }

    public boolean isOwnEnabled(Material material) {
        if (this.ownDisabledMaterials.contains(material)) {
            return false;
        }
        if (this.ownEnabledMaterials.contains(material)) {
            return true;
        }
        if (material.isBlock()) {
            return this.ownEnabledMaterials.isEmpty();
        }
        if (Animals.class.isAssignableFrom(material.getEntityType().getEntityClass())) {
            return Setting.DATABASE_ALLOW_ANIMALS.get();
        }
        if (!LivingEntity.class.isAssignableFrom(material.getEntityType().getEntityClass())) {
            return Setting.DATABASE_ALLOW_ENTITIES.get();
        }
        return false;
    }

    public boolean isIgnoring(User user) {
        return this.ignoringUsers.contains(user);
    }

    public void setIgnoring(User user, boolean enable) {
        if (enable) {
            this.ignoringUsers.add(user);
        } else {
            this.ignoringUsers.remove(user);
        }
    }

    public void addWaiting(User user, WaitType waitType) {
        this.waitingUsers.put(user, waitType);
    }

    public boolean isWaiting(User user, WaitType waitType) {
        return this.waitingUsers.get(user) == waitType;
    }

    public WaitType getWaiting(User user) {
        return this.waitingUsers.get(user);
    }

    public void removeWaiting(User user) {
        this.waitingUsers.remove(user);
    }

    private boolean createDataStructure() {
        File dataFolder = this.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdir()) {
            return false;
        }
        this.getConfig().options().copyDefaults(true);
        if (!this.configFile.exists()) {
            this.saveDefaultConfig();
        }
        if (!Message.loadMessages(this)) {
            return false;
        }
        return this.importerFolder.exists() || this.importerFolder.mkdir();
    }

    private boolean initializeDatabase() {
        if (Setting.DATABASE_MYSQL_ENABLE.get().booleanValue()) {
            try {
                this.database = Setting.DATABASE_MYSQL_PASSWORD.get().equals("") ? new MySqlDatabase(this.getOutput(), this.getDataFolder(), Setting.DATABASE_MYSQL_HOST.get(), Setting.DATABASE_MYSQL_PORT.get(), Setting.DATABASE_MYSQL_DATABASE.get(), Setting.DATABASE_MYSQL_USER.get()) : new MySqlDatabase(this.getOutput(), this.getDataFolder(), Setting.DATABASE_MYSQL_HOST.get(), Setting.DATABASE_MYSQL_PORT.get(), Setting.DATABASE_MYSQL_DATABASE.get(), Setting.DATABASE_MYSQL_USER.get(), Setting.DATABASE_MYSQL_PASSWORD.get());
                this.databaseThread = new Thread((Runnable)this.database, "DatabaseThread");
                this.databaseThread.start();
                return true;
            }
            catch (ClassNotFoundException e) {
                this.getOutput().printException("MySQL driver class not found");
                return false;
            }
            catch (SQLException e) {
                this.getOutput().printException("Exception during MySQL initialization", e);
                return false;
            }
        }
        try {
            this.database = new SqliteDatabase(this.getOutput(), this.getDataFolder());
            this.databaseThread = new Thread((Runnable)this.database, "DatabaseThread");
            this.databaseThread.start();
            return true;
        }
        catch (ClassNotFoundException e) {
            this.getOutput().printException("SQLite driver class not found");
            return false;
        }
        catch (SQLException e) {
            this.getOutput().printException("Exception during SQLite initialization", e);
            return false;
        }
    }

    private boolean initializeProtection() {
        try {
            this.protection = new Protection(this.getOutput(), this.getProtectionFile());
            this.protectionThread = new Thread((Runnable)this.protection, "ProtectionThread");
            this.protectionThread.start();
            return true;
        }
        catch (IOException e) {
            this.getOutput().printException("Exception while loading protections file", e);
            return false;
        }
    }

    private void registerListeners() {
        this.getServer().getPluginManager().registerEvents((Listener)new L_BlockPlace(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new L_EnvironmentDamage(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new L_PlayerInteractEvent(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new L_BlockBreak(this), (Plugin)this);
    }

    private void registerCommands() {
        this.getCommand(Command.IGNORE.toString()).setExecutor((CommandExecutor)new CE_Ignore(this));
        this.getCommand(Command.IGNORE.toString()).setUsage("/<command> [opt.] on/off");
        this.getCommand(Command.IMPORT.toString()).setExecutor((CommandExecutor)new CE_Import(this));
        this.getCommand(Command.IMPORT.toString()).setUsage("/<command> <importer-name>");
        this.getCommand(Command.SHOWOWNER.toString()).setExecutor((CommandExecutor)new CE_ShowOwner(this));
        this.getCommand(Command.SHOWOWNER.toString()).setUsage("/<command> [opt.] e");
        this.getCommand(Command.ADDFRIEND.toString()).setExecutor((CommandExecutor)new CE_AddFriend(this));
        this.getCommand(Command.ADDFRIEND.toString()).setUsage("/<command> <player>");
        this.getCommand(Command.REMFRIEND.toString()).setExecutor((CommandExecutor)new CE_RemFriend(this));
        this.getCommand(Command.REMFRIEND.toString()).setUsage("/<command> <player>");
        this.getCommand(Command.LOCK.toString()).setExecutor((CommandExecutor)new CE_Lock(this));
        this.getCommand(Command.LOCK.toString()).setUsage("/<command> [opt.] e / <material-name>");
        this.getCommand(Command.UNLOCK.toString()).setExecutor((CommandExecutor)new CE_Unlock(this));
        this.getCommand(Command.UNLOCK.toString()).setUsage("/<command> [opt.] e / <material-name>");
        this.getCommand(Command.PROTECT.toString()).setExecutor((CommandExecutor)new CE_Protect(this));
        this.getCommand(Command.PROTECT.toString()).setUsage("/<command> [opt.] e / <material-name>");
        this.getCommand(Command.UNPROTECT.toString()).setExecutor((CommandExecutor)new CE_Unprotect(this));
        this.getCommand(Command.UNPROTECT.toString()).setUsage("/<command> [opt.] e / <material-name>");
        this.getCommand(Command.OWN.toString()).setExecutor((CommandExecutor)new CE_Own(this));
        this.getCommand(Command.OWN.toString()).setUsage("/<command> [opt.] e");
        this.getCommand(Command.UNOWN.toString()).setExecutor((CommandExecutor)new CE_Unown(this));
        this.getCommand(Command.UNOWN.toString()).setUsage("/<command> [opt.] e");
        this.getCommand(Command.LIST.toString()).setExecutor((CommandExecutor)new CE_List(this));
        this.getCommand(Command.LIST.toString()).setUsage("/<command> protected/locked/friends");
        this.getCommand(Command.UNPROTECTPLAYER.toString()).setExecutor((CommandExecutor)new CE_UnprotectPlayer(this));
        this.getCommand(Command.UNPROTECTPLAYER.toString()).setUsage("/<command> <player>");
        this.getCommand(Command.UNOWNPLAYER.toString()).setExecutor((CommandExecutor)new CE_UnownPlayer(this));
        this.getCommand(Command.UNOWNPLAYER.toString()).setUsage("/<command> <player>");
    }

    public Database getOwningDatabase() {
        return this.database;
    }

    public Protection getProtection() {
        return this.protection;
    }

    public boolean isEnabledInWorld(World world) {
        return this.enabledWorlds.contains(world.getName());
    }

    @Override
    public void updateIOException(IOException e) {
        this.getOutput().printException("Error while updating", e);
    }

    @Override
    public void updateInterruptedException(InterruptedException e) {
        this.getOutput().printException("Error while updating", e);
    }

    @Override
    public String getDescription(UpdaterKey key) {
        switch (key) {
            case NAME: {
                return this.getDescription().getName();
            }
            case MAIN_AUTHOR: {
                return (String)this.getDescription().getAuthors().get(0);
            }
            case VERSION: {
                return this.getDescription().getVersion();
            }
        }
        return null;
    }

    @Override
    public void updateNotifyDownloading() {
        this.getOutput().printConsole(Message.UPDATER_DOWNLOADING);
    }

    @Override
    public void updateNotifyRestarting() {
        this.getOutput().printConsole(Message.UPDATER_RESTART);
    }

    @Override
    public void updateNotifyReadUpdatedProjectPage() {
        this.getOutput().printConsole(Message.UPDATER_BIG_UPDATE);
    }

    @Override
    public ReleaseChannel getReleaseChannel() {
        return releaseChannel;
    }

    public static String getDataFolderPath() {
        return DATA_FOLDER_PATH;
    }

    public Output getOutput() {
        return this.output;
    }

    public File getMessageFile() {
        return this.messageFile;
    }

    public File getProtectionFile() {
        return this.protectionFile;
    }

    public File getImporterFolder() {
        return this.importerFolder;
    }
}

