package de.pheasn.blockown.importer;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

import de.pheasn.blockown.Material;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;
import de.pheasn.blockown.database.SqliteDatabase;

public class Sqlite implements Importer {

	@Override
	public void doImport(Database db) throws ImporterException {
		if (db instanceof SqliteDatabase) return;
		try {
			Class.forName("org.sqlite.JDBC");
		} catch (ClassNotFoundException e) {
			throw new ImporterException("No sqlite driver found");
		}

		String url = "jdbc:sqlite:./plugins/BlockOwn/world.db";
		Connection con;
		try {
			con = DriverManager.getConnection(url);
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}

		Statement stmnt;
		try {
			stmnt = con.createStatement();
			ResultSet rs = stmnt.executeQuery("SELECT * FROM block_table;");
			DatabaseAction databaseAction;
			String worldName;
			int x, y, z;
			Material material;
			OwnedBlock block;
			User owner;
			while (rs.next()) {
				worldName = rs.getString("world");
				x = rs.getInt("x");
				y = rs.getInt("y");
				z = rs.getInt("z");
				material = new Material(Bukkit.getServer().getWorld(worldName).getBlockAt(x, y, z).getType());
				owner = new User(UUID.fromString(rs.getString("player_id")));
				block = new OwnedBlock(worldName, x, y, z, material);
				if (db.getOwner(block).isNobody()) {
					databaseAction = new DatabaseAction(DatabaseActionType.OWN, block, owner);
					db.enqueue(databaseAction);
				}
			}
			stmnt.close();
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}

		try {
			HashMap<UUID, EntityType> entities = new HashMap<UUID, EntityType>(1000);
			for (World world : Bukkit.getServer().getWorlds()) {
				for (Entity entity : world.getEntities()) {
					entities.put(entity.getUniqueId(), entity.getType());
				}
			}

			stmnt = con.createStatement();
			ResultSet rs = stmnt.executeQuery("SELECT * FROM entity_table;");
			DatabaseAction databaseAction;
			String worldName;
			OwnedEntity entity;
			User owner;
			while (rs.next()) {
				worldName = rs.getString("world");
				entity = new OwnedEntity(UUID.fromString(rs.getString("entity_id")), entities.get(UUID.fromString(rs.getString("entity_id"))), worldName);
				if (db.getOwner(entity).isNobody()) {
					owner = new User(UUID.fromString(rs.getString("player_id")));
					databaseAction = new DatabaseAction(DatabaseActionType.OWN, entity, owner);
					db.enqueue(databaseAction);
				}
			}
			stmnt.close();
			con.close();
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}
	}

}
