package de.pheasn.blockown.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;

import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;

public class BlockOwn1 implements Importer {

	@SuppressWarnings("deprecation")
	@Override
	public void doImport(Database db) throws ImporterException {
		DatabaseAction databaseAction;

		File configFile = new File("./plugins/BlockOwn1/config.yml");
		if (!configFile.exists()) {
			throw new ImporterException("Old config.yml not found!");
		}
		FileConfiguration config = YamlConfiguration.loadConfiguration(configFile);

		if (!config.getString("Settings-Version").equalsIgnoreCase("1.3.7")) {
			throw new ImporterException("Old config must have version 1.3.7");
		}

		String url = null;
		try {
			if (config.getBoolean("ServerSettings.MySQL.enable")) {
				String type = config.getString("ServerSettings.MySQL.type");
				if (type.equalsIgnoreCase("network")) {
					Class.forName("com.mysql.jdbc.Driver");
					String host = config.getString("ServerSettings.MySQL.host");
					int port = config.getInt("ServerSettings.MySQL.port");
					String databaseName = config.getString("ServerSettings.MySQL.database");
					String username = config.getString("ServerSettings.MySQL.user");
					String password = config.getString("ServerSettings.MySQL.password");
					url = "jdbc:mysql://" + host + ":" + port + "/" + databaseName + "?user="
							+ username + "&password=" + password + "&autoReconnect=true";
				} else {
					Class.forName("org.sqlite.JDBC");
					url = "jdbc:sqlite:./plugins/BlockOwn1/data.db";
				}
			} else {
				importClassic(db);
				return;
			}
		} catch (ClassNotFoundException e) {
			throw new ImporterException("driver class not found");
		}

		try {
			Connection con = DriverManager.getConnection(url);
			Statement stmnt = con.createStatement();
			ResultSet rs = stmnt.executeQuery("SELECT * FROM block INNER JOIN player ON block.ownerid=player.playerid;");

			Ownable ownable;
			boolean isBlock;
			int x, y, z;
			String worldName;
			User owner;
			Block block;
			while (rs.next()) {
				isBlock = rs.getBoolean("isblock");
				worldName = rs.getString("world");
				x = rs.getInt("x");
				y = rs.getInt("y");
				z = rs.getInt("z");
				owner = new User(Bukkit.getServer().getOfflinePlayer(rs.getString("playername")).getUniqueId());
				Location loc = new Location(Bukkit.getServer().getWorld(worldName), x, y, z);
				if (!isBlock) {
					ItemFrame iF = getItemFrame(loc);
					if (iF == null) continue;
					ownable = new OwnedEntity(iF);
				} else {
					block = loc.getBlock();
					if (block.getType() == Material.AIR) continue;
					ownable = new OwnedBlock(block);
				}
				if (db.getOwner(ownable).isNobody()) {
					databaseAction = new DatabaseAction(DatabaseActionType.OWN, ownable, owner);
					db.enqueue(databaseAction);
				}
			}
			stmnt.close();
			con.close();
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}

	}

	private ItemFrame getItemFrame(Location loc) {
		for (Entity entity : loc.getChunk().getEntities()) {
			if (entity instanceof ItemFrame) {
				if (entity.getLocation().getBlockX() == loc.getBlockX() && entity.getLocation().getBlockY() == loc.getBlockY() && entity.getLocation().getBlockZ() == loc.getBlockZ()) {
					return (ItemFrame) entity;
				}
			}
		}
		return null;
	}

	@SuppressWarnings("deprecation")
	private void importClassic(Database db) throws ImporterException {
		File file = new File("./plugins/BlockOwn1/blocks.dat");
		if (!file.exists()) throw new ImporterException("Flat file database doesn't exist");
		try {
			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
			String line = null;
			String[] owningDiv;
			String worldName;
			String[] blockCoordinates;
			boolean isBlock;
			String playerName;
			UUID id;
			User owner;
			World world;
			Location loc;
			Block block;
			DatabaseAction databaseAction;
			Ownable ownable;
			while ((line = br.readLine()) != null) {
				owningDiv = line.split(":"); //$NON-NLS-1$
				worldName = owningDiv[0];
				blockCoordinates = owningDiv[1].split("#"); //$NON-NLS-1$
				playerName = owningDiv[2];
				isBlock = (owningDiv[3].equalsIgnoreCase("1")); //$NON-NLS-1$
				id = Bukkit.getOfflinePlayer(playerName).getUniqueId();
				if (id == null) continue;
				owner = new User(id);
				world = Bukkit.getServer().getWorld(worldName);
				loc = new Location(world, Integer.parseInt(blockCoordinates[0]), Integer.parseInt(blockCoordinates[1]), Integer.parseInt(blockCoordinates[2]));
				block = Bukkit.getServer().getWorld(worldName).getBlockAt(loc);
				if (isBlock) {
					if (!block.getType().equals(Material.AIR)) {
						ownable = new OwnedBlock(block);
					} else continue;
				} else {
					ItemFrame iF = getItemFrame(block.getLocation());
					if (iF != null) {
						ownable = new OwnedEntity(iF);
					} else continue;
				}
				if (db.getOwner(ownable).isNobody()) {
					databaseAction = new DatabaseAction(DatabaseActionType.OWN, ownable, owner);
					db.enqueue(databaseAction);
				}
			}
			br.close();
		} catch (FileNotFoundException e) {
			throw new ImporterException(e.getMessage());
		} catch (IOException e) {
			throw new ImporterException(e.getMessage());
		}
	}
}
