package de.pheasn.blockown.event;

import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.StructureGrowEvent;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;
import de.pheasn.blockown.protection.ProtectAction;
import de.pheasn.blockown.protection.ProtectActionType;

public class L_BlockPlace extends Listener {

	public L_BlockPlace(BlockOwn plugin) {
		super(plugin);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockPlace(BlockPlaceEvent event) {
		Player player = event.getPlayer();
		if (plugin.isEnabledInWorld(player.getWorld())) {
			if (player.hasPermission(Permission.OWN_PLACE.toString())) {
				User user = new User(player.getUniqueId());
				OwnedBlock block = new OwnedBlock(event.getBlock());
				if (plugin.isOwnEnabled(block.getMaterial())) {
					DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, block, user);
					plugin.getOwningDatabase().enqueue(databaseAction);
				}
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onHangingPlace(HangingPlaceEvent event) {
		if (plugin.isEnabledInWorld(event.getBlock().getWorld())) {
			if (event.getPlayer().hasPermission(Permission.OWN_PLACE.toString())) {
				OwnedEntity entity = new OwnedEntity(event.getEntity());
				User owner = new User(event.getPlayer().getUniqueId());
				if (plugin.isOwnEnabled(entity.getMaterial())) {
					DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, entity, owner);
					plugin.getOwningDatabase().enqueue(databaseAction);
				}
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockMultiPlace(BlockMultiPlaceEvent event) {
		Player player = event.getPlayer();
		if (plugin.isEnabledInWorld(player.getWorld())) {
			if (player.hasPermission(Permission.OWN_PLACE.toString())) {
				User user = new User(player.getUniqueId());
				OwnedBlock block;
				DatabaseAction databaseAction;
				for (BlockState state : event.getReplacedBlockStates()) {
					block = new OwnedBlock(state.getBlock());
					if (plugin.isOwnEnabled(block.getMaterial())) {
						databaseAction = new DatabaseAction(DatabaseActionType.OWN, block, user);
						plugin.getOwningDatabase().enqueue(databaseAction);
					}
				}
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockGrow(StructureGrowEvent event) {
		if (plugin.isEnabledInWorld(event.getWorld())) {
			OwnedBlock block = new OwnedBlock(event.getLocation().getBlock());
			User owner = plugin.getOwningDatabase().getOwner(block);

			if (owner.isNobody()) return;
			DatabaseAction databaseAction;
			for (BlockState state : event.getBlocks()) {
				block = new OwnedBlock(state.getBlock());
				databaseAction = new DatabaseAction(DatabaseActionType.OWN, block, owner);
				plugin.getOwningDatabase().enqueue(databaseAction);
			}
		}
	}

	@EventHandler(priority = EventPriority.HIGH, ignoreCancelled = true)
	public void onBlockPlaceNearChest(BlockPlaceEvent event) {
		Player player = event.getPlayer();
		if (plugin.isEnabledInWorld(player.getWorld())) {
			if (event.getBlock().getType() != org.bukkit.Material.CHEST) {
				return;
			}
			User user = new User(event.getPlayer().getUniqueId());
			Block blockRight = event.getBlock().getRelative(1, 0, 0);
			Block blockLeft = event.getBlock().getRelative(-1, 0, 0);
			Block blockFront = event.getBlock().getRelative(0, 0, 1);
			Block blockBack = event.getBlock().getRelative(0, 0, -1);
			if (blockLeft.getType() == org.bukkit.Material.CHEST) {
				if (!validPlacement(blockLeft, user)) {
					event.setCancelled(true);
					return;
				}
			}
			if (blockRight.getType() == org.bukkit.Material.CHEST) {
				if (!validPlacement(blockRight, user)) {
					event.setCancelled(true);
					return;
				}
			}
			if (blockFront.getType() == org.bukkit.Material.CHEST) {
				if (!validPlacement(blockFront, user)) {
					event.setCancelled(true);
					return;
				}
			}
			if (blockBack.getType() == org.bukkit.Material.CHEST) {
				if (!validPlacement(blockBack, user)) {
					event.setCancelled(true);
					return;
				}
			}
		}
	}

	/**
	 * Handle entity choosing
	 * 
	 * @param event
	 */
	@EventHandler(priority = EventPriority.MONITOR)
	public void onPlayerChooseEntity(PlayerInteractEntityEvent event) {
		if (!plugin.isEnabledInWorld(event.getRightClicked().getWorld())) return;
		User user = new User(event.getPlayer().getUniqueId());
		OwnedEntity entity = new OwnedEntity(event.getRightClicked());

		WaitType waitType = plugin.getWaiting(user);
		if (waitType == null) return;

		if (!plugin.isOwnEnabled(entity.getMaterial())) return;
		User owner = plugin.getOwningDatabase().getOwner(entity);
		Player player = event.getPlayer();

		ProtectAction protectAction;
		DatabaseAction databaseAction;
		switch (waitType) {
		case SHOW_OWNER:
			if (owner.isNobody()) {
				plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_BLOCK_UNOWNED);
			} else {
				plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_BLOCK_FOUND, owner.getName());
			}
			break;
		case OWN:
			if (owner.isNobody()) {
				databaseAction = new DatabaseAction(DatabaseActionType.OWN, entity, user);
				plugin.getOwningDatabase().enqueue(databaseAction);
				plugin.getOutput().sendMessage(player, Message.COMMAND_OWN_ENTITYSUCCESS, entity.getMaterial().getName());
			} else {
				plugin.getOutput().sendMessage(event.getPlayer(), Message.COMMAND_OWN_NOPERMISSIONFOROTHERS);
			}
			break;
		case UNOWN:
			if (owner.equals(owner) || player.hasPermission(Permission.ADMIN_UNOWN.toString())) {
				databaseAction = new DatabaseAction(DatabaseActionType.UNOWN, entity);
				plugin.getOwningDatabase().enqueue(databaseAction);
				plugin.getOutput().sendMessage(event.getPlayer(), Message.COMMAND_UNOWN_ENTITYSUCCESS, entity.getMaterial().getName());
			} else {
				plugin.getOutput().sendMessage(event.getPlayer(), Message.COMMAND_UNOWN_FOROTHERS_NOTALLOWED);
			}
			break;
		case PROTECT:
			protectAction = new ProtectAction(ProtectActionType.PROTECT, user, entity.getMaterial());
			plugin.getProtection().enqueue(protectAction);
			plugin.getOutput().sendMessage(player, Message.COMMAND_PROTECT_SUCCESS, entity.getMaterial().getName());
			break;
		case UNPROTECT:
			protectAction = new ProtectAction(ProtectActionType.UNPROTECT, user, entity.getMaterial());
			plugin.getProtection().enqueue(protectAction);
			plugin.getOutput().sendMessage(player, Message.COMMAND_UNPROTECT_SUCCESS, entity.getMaterial().getName());
			break;
		case LOCK:
			protectAction = new ProtectAction(ProtectActionType.LOCK, user, entity.getMaterial());
			plugin.getProtection().enqueue(protectAction);
			plugin.getOutput().sendMessage(player, Message.COMMAND_LOCK_SUCCESS, entity.getMaterial().getName());
			break;
		case UNLOCK:
			protectAction = new ProtectAction(ProtectActionType.UNLOCK, user, entity.getMaterial());
			plugin.getProtection().enqueue(protectAction);
			plugin.getOutput().sendMessage(player, Message.COMMAND_UNLOCK_SUCCESS, entity.getMaterial().getName());
			break;
		default:
			break;
		}
		plugin.removeWaiting(user);
	}

	private boolean validPlacement(Block nativeBlock, User user) {
		OwnedBlock block = new OwnedBlock(nativeBlock);
		User owner = plugin.getOwningDatabase().getOwner(block);
		if (owner.isNobody()) return true;
		if (owner.equals(user)) return true;
		if (plugin.getProtection().isProtected(owner, block.getMaterial()) || plugin.getProtection().isLocked(owner, block.getMaterial())) {
			return false;
		}
		return true;
	}
}
