package de.pheasn.blockown.event;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.hanging.HangingBreakEvent;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;

public class L_BlockBreak extends Listener {

	private final Set<org.bukkit.Material> droppingMaterials;

	public L_BlockBreak(BlockOwn plugin) {
		super(plugin);
		droppingMaterials = new HashSet<org.bukkit.Material>(11, 1);
		droppingMaterials.addAll(Arrays.asList(new org.bukkit.Material[] {
				org.bukkit.Material.WOODEN_DOOR,
				org.bukkit.Material.WOOD_DOOR,
				org.bukkit.Material.IRON_DOOR,
				org.bukkit.Material.IRON_DOOR_BLOCK,
				org.bukkit.Material.TORCH,
				org.bukkit.Material.RED_ROSE,
				org.bukkit.Material.YELLOW_FLOWER,
				org.bukkit.Material.BED,
				org.bukkit.Material.BED_BLOCK,
				org.bukkit.Material.RAILS,
				org.bukkit.Material.DOUBLE_PLANT
		}));
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockBreak(BlockBreakEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = new OwnedBlock(event.getBlock());
		unown(block);
		Block topBlock = event.getBlock().getRelative(0, 1, 0);
		if (droppingMaterials.contains(topBlock.getType())) {
			unown(new OwnedBlock(topBlock));
		}
	}

	/**
	 * Handle blocks that have a block on top which would get dropped if the block breaks
	 * 
	 * @param event
	 */
	@EventHandler(priority = EventPriority.HIGH, ignoreCancelled = true)
	public void onBlockBreakBefore(BlockBreakEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		Block topBlock = event.getBlock().getRelative(0, 1, 0);
		if (droppingMaterials.contains(topBlock.getType())) {
			OwnedBlock block = new OwnedBlock(topBlock);
			User owner = plugin.getOwningDatabase().getOwner(block);
			if (owner.isNobody()) return;
			if (plugin.getProtection().isProtected(owner, block.getMaterial()) || plugin.getProtection().isLocked(owner, block.getMaterial())) {
				event.setCancelled(true);
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onHangingBreak(HangingBreakEvent event) {
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;

		OwnedEntity entity = new OwnedEntity(event.getEntity());
		unown(entity);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onDeath(EntityDeathEvent event) {
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
		OwnedEntity entity = new OwnedEntity(event.getEntity());
		unown(entity);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onPhysics(BlockPhysicsEvent event) {
		if (plugin.isEnabledInWorld(event.getBlock().getWorld())) {
			org.bukkit.Material material = event.getChangedType();

			if (material == org.bukkit.Material.SAND || material == org.bukkit.Material.GRAVEL) {
				OwnedBlock block = new OwnedBlock(event.getBlock());
				unown(block);
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onFade(BlockFadeEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = new OwnedBlock(event.getBlock());
		unown(block);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onLeavesDecay(LeavesDecayEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = new OwnedBlock(event.getBlock());
		unown(block);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockBurn(BlockBurnEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = new OwnedBlock(event.getBlock());
		unown(block);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockExploded(EntityExplodeEvent event) {
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
		Iterator<Block> iterator = event.blockList().iterator();
		OwnedBlock block;

		while (iterator.hasNext()) {
			block = new OwnedBlock(iterator.next());
			unown(block);
		}
	}

	private void unown(Ownable ownable) {
		DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.UNOWN, ownable);
		plugin.getOwningDatabase().enqueue(databaseAction);
	}
}
