package de.pheasn.blockown.database;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.User;

public abstract class CachedDatabase extends Database {

	private final Cache cache;

	protected CachedDatabase(BlockOwn plugin) {
		super(plugin);
		cache = new Cache(this);
	}

	@Override
	public User getOwner(Ownable ownable) {
		return cache.getOwner(ownable);
	}

	@Override
	public void run() {
		DatabaseAction databaseAction;
		while (!disable || !queue.isEmpty()) {
			if (!queue.isEmpty()) {
				databaseAction = queue.remove();
				if (!cache.doAction(databaseAction)) {
					plugin.getOutput().printException(new ActionNotPerformedException(databaseAction));
				}
			} else {
				cache.flush();
				if (!disable || !queue.isEmpty()) continue;
				try {
					synchronized (LOCK) {
						while (!disable && queue.isEmpty()) {
							LOCK.wait();
						}
					}
				} catch (InterruptedException e) {
					plugin.getOutput().printException("Database thread has been interrupted.", e);
				}
			}
		}
		// Flush cache before thread is ending
		cache.flush();
		close();
	}
}
