package de.pheasn.blockown.command;

import java.util.Iterator;
import java.util.NoSuchElementException;

import org.bukkit.Location;
import org.bukkit.block.Block;

class RegionIterator implements Iterator<Block> {

	private final Location min;
	private final Location max;

	private Location position = null;

	public RegionIterator(Location min, Location max) {
		this.min = min;
		this.max = max;
	}

	@Override
	public boolean hasNext() {
		if (min.getBlockX() == max.getBlockX() &&
				min.getBlockY() == max.getBlockY() &&
				min.getBlockZ() == max.getBlockZ()) {
			return false;
		} else {
			return true;
		}
	}

	@Override
	public Block next() {
		if (position == null) position = min.clone();
		else {
			if (position.getBlockX() != max.getBlockX()) position.add(1, 0, 0);
			else {
				position.setX(min.getBlockX());
				if (position.getBlockY() != max.getBlockY()) position.add(0, 1, 0);
				else {
					position.setY(min.getBlockY());
					if (position.getBlockZ() != max.getBlockZ()) position.add(0, 0, 1);
					else throw new NoSuchElementException();
				}
			}

		}
		return position.getBlock();
	}

	@Override
	public void remove() {
		return;
	}
}
