package de.pheasn.blockown.command;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.Selection;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;

public class CE_Unown extends CommandExecutor {

	private static final String PARAM_SELECTION = "selection";
	private static final String PARAM_ENTITY = "e";

	private final WorldEditPlugin worldEdit;

	public CE_Unown(BlockOwn plugin) {
		super(plugin);
		worldEdit = (WorldEditPlugin) plugin.getServer().getPluginManager().getPlugin("WorldEdit");
	}

	@Override
	protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		if (!player.hasPermission(Permission.OWN_UNOWN.toString())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
			return true;
		}

		if (!plugin.isEnabledInWorld(player.getWorld())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_DISABLED_IN_WORLD);
			return true;
		}

		User user = new User(player.getUniqueId());
		if (args.length == 1) {
			if (args[0].equalsIgnoreCase(PARAM_SELECTION)) {
				if (!player.hasPermission(Permission.OWN_OWNSELECTION.toString())) {
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
					return true;
				}
			} else if (args[0].equalsIgnoreCase(PARAM_ENTITY)) {
				if (plugin.isWaiting(user, WaitType.UNOWN)) {
					plugin.removeWaiting(user);
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
				} else {
					plugin.addWaiting(user, WaitType.UNOWN);
					plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_CLICK_SOMEWHERE);
				}
				return true;
			} else {
				return false;
			}

			if (worldEdit != null) {
				Selection selection = worldEdit.getSelection(player);
				Location min = selection.getMinimumPoint();
				Location max = selection.getMaximumPoint();
				RegionIterator region = new RegionIterator(min, max);
				Block bukkitBlock;
				OwnedBlock block;
				int ownedCounter = 0;
				while (region.hasNext()) {
					bukkitBlock = region.next();
					block = new OwnedBlock(bukkitBlock);
					if (bukkitBlock.getType() != org.bukkit.Material.AIR && plugin.isOwnEnabled(block.getMaterial())) {
						if (plugin.getOwningDatabase().getOwner(block).equals(user) || player.hasPermission(Permission.ADMIN_UNOWN.toString())) {
							DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.UNOWN, block);
							plugin.getOwningDatabase().enqueue(databaseAction);
							ownedCounter++;
						}
					}
				}
				plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_SELECTION_SUCCESS, ownedCounter);
				return true;
			} else {
				plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_SELECTION_NOWORLDEDIT);
				return true;
			}

		} else if (args.length == 0) {
			@SuppressWarnings("deprecation")
			Block targetBlock = player.getTargetBlock(null, 20);
			if (targetBlock != null) {
				OwnedBlock block = new OwnedBlock(targetBlock);
				if (plugin.getOwningDatabase().getOwner(block).equals(user) || player.hasPermission(Permission.ADMIN_UNOWN.toString())) {
					DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.UNOWN, block);
					plugin.getOwningDatabase().enqueue(databaseAction);
					plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_BLOCKSUCCESS, block.getMaterial().getName());
					return true;
				} else {
					plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_FOROTHERS_NOTALLOWED);
					return false;
				}
			} else {
				plugin.getOutput().sendMessage(player, Message.COMMAND_NOTARGET);
				return false;
			}
		} else {
			return false;
		}
	}
}
