package de.pheasn.blockown.command;

import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;

public class CE_ShowOwner extends CommandExecutor {

	private static final String PARAM_ENTITY = "e";

	public CE_ShowOwner(BlockOwn plugin) {
		super(plugin);
	}

	@Override
	public boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		if (!player.hasPermission(Permission.OWN_SHOWOWNER.toString())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
			return true;
		}

		if (!plugin.isEnabledInWorld(player.getWorld())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_DISABLED_IN_WORLD);
			return true;
		}

		if (args.length == 1 && args[0].equalsIgnoreCase(PARAM_ENTITY)) {
			User user = new User(player.getUniqueId());
			if (plugin.isWaiting(user, WaitType.SHOW_OWNER)) {
				plugin.removeWaiting(user);
				plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
			} else {
				plugin.addWaiting(user, WaitType.SHOW_OWNER);
				plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_CLICK_SOMEWHERE);
			}
			return true;
		}

		@SuppressWarnings("deprecation")
		Block block = player.getTargetBlock(null, 20);
		if (block != null) {
			User owner = plugin.getOwningDatabase().getOwner(new OwnedBlock(block));
			if (owner.isNobody()) {
				plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_BLOCK_UNOWNED);
			} else {
				plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_BLOCK_FOUND, owner.getName());
			}
			return true;
		} else {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NOTARGET);
			return false;
		}

	}
}
