package de.pheasn.blockown.command;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.importer.Importer;
import de.pheasn.blockown.importer.ImporterException;

public class CE_Import extends CommandExecutor {

	public CE_Import(BlockOwn plugin) {
		super(plugin);
	}

	@Override
	public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
		if (!sender.hasPermission(Permission.ADMIN_IMPORT.toString())) {
			plugin.getOutput().sendMessage(sender, Message.COMMAND_NO_PERMISSION);
			return false;
		}

		if (args.length != 1) return false;
		Class<? extends Importer> importerClass;
		try {
			importerClass = findClass(args[0]);
		} catch (ClassNotFoundException e) {
			plugin.getOutput().printException("No matching importer found", e);
			return false;
		}
		try {
			Importer importer = importerClass.newInstance();
			plugin.getOutput().sendMessage(sender, Message.COMMAND_IMPORT_START);
			importer.doImport(plugin.getOwningDatabase());
			plugin.getOutput().sendMessage(sender, Message.COMMAND_IMPORT_SUCCESS);
			return true;
		} catch (InstantiationException | IllegalAccessException e) {
			plugin.getOutput().printException("There probably was an error in the requested importer class", e);
			return false;
		} catch (ImporterException e) {
			plugin.getOutput().printException(e.getMessage(), e);
			return false;
		}

	}

	@Override
	protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		return false;
	}

	@SuppressWarnings("unchecked")
	private Class<? extends Importer> findClass(String name) throws ClassNotFoundException {
		Class<? extends Importer> result = null;
		try {
			Class<?> found = Class.forName("de.pheasn.blockown.importer." + name);
			if (Importer.class.isAssignableFrom(found) && !found.isInterface()) {
				result = (Class<? extends Importer>) found;
			}
		} catch (ClassNotFoundException e) {
			URL url;
			try {
				url = plugin.getImporterFolder().toURI().toURL();
				URLClassLoader loader = URLClassLoader.newInstance(new URL[] { url }, plugin.getClass().getClassLoader());
				Class<?> found = loader.loadClass(name);
				if (Importer.class.isAssignableFrom(found) && !found.isInterface()) {
					result = (Class<? extends Importer>) found;
				}
			} catch (MalformedURLException e1) {
				plugin.getOutput().printException(e1);
			}
		}
		if (result == null) throw new ClassNotFoundException();
		return result;
	}

}
