package de.pheasn.blockown;

import java.io.Serializable;
import java.util.UUID;

import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class User implements Serializable {

	private static final long serialVersionUID = -9170381319637300740L;
	public static final User nobody = new User(null);
	private static BlockOwn plugin = null;

	private final UUID id;

	public User(UUID id) {
		this.id = id;
	}

	static synchronized void initialize(BlockOwn plugin) {
		User.plugin = plugin;
	}

	public UUID getId() {
		return id;
	}

	public boolean isOnline() {
		OfflinePlayer o = getOfflinePlayer();
		return (o == null) ? false : o.isOnline();
	}

	public boolean isOp() {
		OfflinePlayer o = getOfflinePlayer();
		return (o == null) ? false : o.isOp();
	}

	/**
	 * Gets the last known name of the Player represented by this User
	 *
	 * @return the name
	 */
	public String getName() {
		OfflinePlayer o = getOfflinePlayer();
		return (o == null) ? null : o.getName();
	}

	public OfflinePlayer getOfflinePlayer() {
		return getPlugin().getServer().getOfflinePlayer(id);
	}

	public World getWorld() {
		if (isNobody()) return null;
		Player player = getPlugin().getServer().getPlayer(id);
		if (player == null) return null;
		return player.getWorld();
	}

	public boolean isNobody() {
		return id == null;
	}

	private BlockOwn getPlugin() {
		return plugin;
	}

	public boolean hasAccess(Ownable ownable) {
		User owner = getPlugin().getOwningDatabase().getOwner(ownable);
		if (owner == null) return true;
		return hasAccess(ownable.getMaterial(), owner);
	}

	public boolean hasAccess(Material material, User owner) {
		return getPlugin().getProtection().hasAccess(owner, material, this);
	}

	public boolean hasProtected(Material material) {
		return getPlugin().getProtection().isProtected(this, material);
	}

	public boolean hasLocked(Material material) {
		return getPlugin().getProtection().isLocked(this, material);
	}

	public boolean hasFriend(User user) {
		return getPlugin().getProtection().isFriend(this, user);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		User other = (User) obj;
		if (id == null) {
			if (other.id != null) return false;
		} else if (!id.equals(other.id)) return false;
		return true;
	}

	@Override
	public String toString() {
		String name = getName();
		return (name == null) ? "Nobody" : name;
	}
}
