package de.pheasn.blockown;

import java.util.List;

import org.bukkit.Bukkit;

import de.pheasn.pluginupdater.ReleaseChannel;

public class Setting<T> {

	public static final Setting<String> VERSION = new Setting<String>("version");
	public static final Setting<Boolean> DEBUG_MODE = new Setting<Boolean>("debug-mode");
	public static final Setting<List<String>> ENABLED_WORLDS = new Setting<List<String>>("enabledWorlds");
	public static final Setting<List<String>> DISABLED_WORLDS = new Setting<List<String>>("disabledWorlds");

	public static final Setting<Boolean> UPDATER_ENABLE = new Setting<Boolean>("Updater.enable");
	public static final Setting<String> UPDATER_RELEASE_CHANNEL = new Setting<String>("Updater.release-channel");
	public static final Setting<String> UPDATER_API_KEY = new Setting<String>("Updater.apiKey");

	public static final Setting<Boolean> DATABASE_MYSQL_ENABLE = new Setting<Boolean>("Database.MySQL.enable");
	public static final Setting<String> DATABASE_MYSQL_HOST = new Setting<String>("Database.MySQL.host");
	public static final Setting<Integer> DATABASE_MYSQL_PORT = new Setting<Integer>("Database.MySQL.port");
	public static final Setting<String> DATABASE_MYSQL_DATABASE = new Setting<String>("Database.MySQL.database");
	public static final Setting<String> DATABASE_MYSQL_USER = new Setting<String>("Database.MySQL.user");
	public static final Setting<String> DATABASE_MYSQL_PASSWORD = new Setting<String>("Database.MySQL.password");

	public static final Setting<Boolean> DATABASE_ALLOW_ENTITIES = new Setting<Boolean>("Database.allowEntities");
	public static final Setting<Boolean> DATABASE_ALLOW_ANIMALS = new Setting<Boolean>("Database.allowAnimals");
	public static final Setting<List<String>> DATABASE_ALLOWED_MATERIALS = new Setting<List<String>>("Database.allowedMaterials");
	public static final Setting<List<String>> DATABASE_DISALLOWED_MATERIALS = new Setting<List<String>>("Database.disallowedMaterials");

	public static final Setting<Boolean> PROTECTION_AUTO_PROTECT_OWNED_BLOCKS = new Setting<Boolean>("Protection.autoProtectOwnedBlocks");
	public static final Setting<Boolean> PROTECTION_AUTO_PROTECT_OWNED_ENTITIES = new Setting<Boolean>("Protection.autoProtectOwnedEntities");
	public static final Setting<Boolean> PROTECTION_AUTO_PROTECT_OWNED_ANIMALS = new Setting<Boolean>("Protection.autoProtectOwnedAnimals");
	public static final Setting<List<String>> PROTECTION_AUTO_PROTECT_MATERIALS = new Setting<List<String>>("Protection.autoProtectMaterials");
	public static final Setting<List<String>> PROTECTION_ALLOWED_MATERIALS = new Setting<List<String>>("Protection.allowedMaterials");
	public static final Setting<List<String>> PROTECTION_DISALLOWED_MATERIALS = new Setting<List<String>>("Protection.disallowedMaterials");
	public static final Setting<Boolean> PROTECTION_PROTECT_AGAINST_ENVIRONMENT = new Setting<Boolean>("Protection.protectAgainstEnvironment");
	public static final Setting<Boolean> PROTECTION_PROTECT_ONLY_LEFT_CLICKS = new Setting<Boolean>("Protection.onlyLeftClicks");

	private final BlockOwn plugin;
	private final String path;

	private Setting(String path) {
		plugin = (BlockOwn) Bukkit.getPluginManager().getPlugin("BlockOwn");
		this.path = path;
	}

	public T get() {
		try {
			Object o = plugin.getConfig().get(path);
			if (o == null) return null;

			@SuppressWarnings("unchecked")
			T t = (T) o;
			return t;
		} catch (ClassCastException e) {
			plugin.getOutput().printException("Setting wasn't available in correct type", e);
			return null;
		}
	}

	public ReleaseChannel getReleaseChannel() {
		try {
			return ReleaseChannel.valueOf(plugin.getConfig().getString(path).toUpperCase());
		} catch (IllegalArgumentException e) {
			plugin.getOutput().printException(e);
			return null;
		}
	}

	public void set(Object value) {
		plugin.getConfig().set(path, value);
	}

	/**
	 * Returns the settings path represented by this Setting
	 */
	@Override
	public String toString() {
		return path;
	}

}
