package de.pheasn.blockown;

import java.lang.ref.WeakReference;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class OwnedEntity implements Ownable {

	private static final long serialVersionUID = -5197934920645104143L;

	private transient WeakReference<Entity> entityRef;

	private final UUID id;
	private final String worldName;
	private final Material material;

	public OwnedEntity(Entity entity) {
		this.worldName = entity.getWorld().getName();
		this.id = entity.getUniqueId();
		this.entityRef = new WeakReference<Entity>(entity);
		this.material = new Material(entity.getType());
	}

	public OwnedEntity(UUID id, EntityType entityType, String worldName) {
		this.id = id;
		this.worldName = worldName;
		this.material = new Material(entityType);
	}

	public Entity getEntity() {
		Entity result = (entityRef == null) ? null : entityRef.get();
		if (result == null) {
			for (Entity entity : getWorld().getEntitiesByClass(material.getEntityType().getEntityClass())) {
				if (entity.getUniqueId().equals(id)) {
					entityRef = new WeakReference<Entity>(entity);
					return entity;
				}
			}
			return null;
		} else {
			return result;
		}
	}

	public UUID getUniqueId() {
		return id;
	}

	@Override
	public World getWorld() {
		return Bukkit.getServer().getWorld(worldName);
	}

	@Override
	public String getWorldName() {
		return worldName;
	}

	@Override
	public Material getMaterial() {
		return material;
	}

	public boolean isLiving() {
		return (getEntity() instanceof LivingEntity);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) return true;
		if (obj == null) return false;
		if (getClass() != obj.getClass()) return false;
		OwnedEntity other = (OwnedEntity) obj;
		if (id == null) {
			if (other.id != null) return false;
		} else if (!id.equals(other.id)) return false;
		return true;
	}

	@Override
	public String toString() {
		return "OwnedEntity [id=" + id + ", worldName=" + worldName + ", material=" + material + "]";
	}

}
