package de.pheasn.blockown;

import java.text.MessageFormat;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class Output {

	private ConsoleCommandSender console;
	private final String pluginName = "[BlockOwn] ";

	Output() {
		console = Bukkit.getServer().getConsoleSender();
	}

	/**
	 * Prints out "An exception occurred" to the console
	 *
	 * @param e
	 *            the exception
	 */
	public void printException(Exception e) {
		// Don't bug normal users with exception details
		printConsole(ChatColor.RED + "An exception occurred.");
	}

	/**
	 * Prints the message to console
	 *
	 * @param message
	 *            the message. Should be user readable
	 */
	public void printException(String message) {
		// Don't bug normal users with exception details
		printConsole(ChatColor.RED + message);
	}

	/**
	 * Prints the message to console
	 * 
	 * @param message
	 *            the message, Should be user readable
	 * @param e
	 *            the exception
	 */
	public void printException(String message, Exception e) {
		printException(ChatColor.RED + message);
	}

	/**
	 * Prints message to console.
	 *
	 * @param message
	 *            the message
	 */
	public void printConsole(Message message) {
		console.sendMessage(pluginName + message.toString());
	}

	protected void printConsole(String message) {
		console.sendMessage(pluginName + message);
	}

	/**
	 * Send a message to a CommandSender
	 *
	 * @param sender
	 *            the sender
	 * @param message
	 *            the message
	 */
	public void sendMessage(CommandSender sender, Message message) {
		if (message.toString().isEmpty()) return;
		if (sender instanceof Player) {
			sender.sendMessage(message.toString());
		} else {
			printConsole(message);
		}
	}

	/**
	 * Send a CommandSender a message
	 *
	 * @param sender
	 *            the sender
	 * @param message
	 *            the message
	 * @param params
	 *            the parameters
	 */
	public void sendMessage(CommandSender sender, Message message, Object... params) {
		if (message.toString().isEmpty()) return;
		String messageString = MessageFormat.format(message.toString(), params);
		if (sender instanceof Player) {
			sender.sendMessage(messageString);
		} else {
			printConsole(messageString);
		}
	}

	/**
	 * Broadcast a message on the whole server
	 * 
	 * @param message
	 *            the message
	 */
	public void broadcast(Message message) {
		printConsole(message);
		for (World world : Bukkit.getServer().getWorlds()) {
			broadcastInWorld(world, message);
		}
	}

	/**
	 * Broadcast a message in a specific world
	 * 
	 * @param world
	 *            the world
	 * @param message
	 *            the message
	 */
	public void broadcast(World world, Message message) {
		printConsole(message);
		broadcastInWorld(world, message);
	}

	private void broadcastInWorld(World world, Message message) {
		for (Player player : world.getPlayers()) {
			player.sendMessage(message.toString());
		}
	}

	/**
	 * Prints a debug message
	 * 
	 * @param message
	 *            the message
	 */
	public void debugMessage(String message) {
		// Don't print debug Messages in normal output mode
	}
}
