package de.pheasn.blockown;

public class DebugOutput extends Output {

	/**
	 * Prints out the stack trace to console
	 * 
	 * @param e
	 *            the exception
	 */
	@Override
	public void printException(Exception e) {
		e.printStackTrace();
	}

	/**
	 * Prints a message followed by a stack trace to console
	 * 
	 * @param message
	 *            the message
	 * @param e
	 *            the exception
	 */
	@Override
	public void printException(String message, Exception e) {
		printConsole(message);
		e.printStackTrace();
	}

	/**
	 * Prints debug message to console
	 * 
	 * @param message
	 *            the message
	 */
	@Override
	public void debugMessage(String message) {
		printConsole(message);
	}

}
