# License List Data

This repository contains various generated data formats for the [SPDX License List](http://spdx.org/licenses/) including RDFa, HTML, Text, and JSON. The source of the license list which generates these data files can be found at http://github.com/spdx/license-list.

The following directories contain the license list in the format specified:

* `html` - Simple HTML format of the files. (*Note:* These pages are not complete and valid HTML files, but simply HTML snippets for the license text.)
* `json` - JSON format for the license list.
* `rdfa` - RDFa/HTML format for the license list.
* `template` - SPDX template files per the license templates specified in the SPDX 2.0 specification appendix.
* `text` - Simple text files.
* `website` - HTML generated for the http://spdx.org/ website.

Technical questions or issues can be sent to the [SPDX technical team mailing list](mailto:spdx-tech@lists.spdx.org).
Questions or issues on the license content can be sent to the [SPDX legal team mailing list](mailto:spdx-legal@lists.spdx.org).

Note that the content of this repository is generated by the [SPDX tools](http://github.com/spdx/tools) from the [license list source](http://github.com/spdx/license-list).

As far as the *content* of the license information is concerned, any [issues](https://github.com/spdx/license-list/issues) or [pull requests](https://github.com/spdx/license-list/pulls) should be logged at the [license list source](http://github.com/spdx/license-list) project.

As far as the output *format* or the *generation* of the output files is concerned, any [issues](https://github.com/spdx/tools/issues) or [pull requests](https://github.com/spdx/tools/pulls) should be logged at the [SPDX tools](http://github.com/spdx/tools) project.
