/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.roast.nio;

import de.pfabulist.roast.nio.Path_;
import de.pfabulist.roast.types.NonnullCheck;
import de.pfabulist.roast.unchecked.Unchecked;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public final class Paths_ {
    public static final String DEFAULT_FILESYSTEM_SCHEME = "file";

    private Paths_() {
    }

    public static Path getTmpDir(String prefix) {
        return FileSystems.getDefault().getPath((String)NonnullCheck.n_((Object)System.getProperty("java.io.tmpdir")), prefix + "-" + Paths_.fsFriendlyName(Clock.systemUTC().instant()));
    }

    public static Path_ getTmpDir__(String prefix) {
        return Path_.r_(Paths_.getTmpDir(prefix));
    }

    public static String fsFriendlyName(Instant inst) {
        return Paths_.getDateTimeString(inst);
    }

    public static String getDateTimeString(Instant instant) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd--HH-mm-ss--SSS").withZone(ZoneId.systemDefault());
        return formatter.format(instant);
    }

    public static FileSystem getOrCreate(URI uri, Map<String, ?> env) {
        String scheme = Optional.ofNullable(uri.getScheme()).orElseThrow(() -> new IllegalArgumentException("not a correct uri: " + uri));
        if (scheme.equals(DEFAULT_FILESYSTEM_SCHEME)) {
            return FileSystems.getDefault();
        }
        try {
            return FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException exp) {
            try {
                return FileSystems.newFileSystem(uri, env);
            }
            catch (IOException e) {
                throw Unchecked.u((Throwable)e);
            }
        }
    }

    public static Path get_(URI uri, Map<String, ?> env) {
        try {
            return Paths.get(uri);
        }
        catch (FileSystemNotFoundException e) {
            Paths_.getOrCreate(uri, env);
            return Paths.get(uri);
        }
    }

    public static Path_ get__(URI uri) {
        return Path_.r_(Paths_.get_(uri, Collections.emptyMap()));
    }

    public static Path get_(String first, String ... more) {
        return (Path)NonnullCheck.n_((Object)Paths.get(first, more));
    }

    public static Path_ get__(String first, String ... more) {
        return Path_.r_(Paths_.get_(first, more));
    }

    public static Path getPath(String str, Map<String, ?> env) {
        URI uri = URI.create(str);
        if (uri.getScheme() == null) {
            throw new IllegalArgumentException("not a uri with scheme " + uri);
        }
        return Paths_.get_(uri, env);
    }
}

