/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.roast.nio;

import de.pfabulist.roast.collection.Map_;
import de.pfabulist.roast.nio.DirectoryStream_;
import de.pfabulist.roast.nio.Path_;
import de.pfabulist.roast.nio.SeekableByteChannel_;
import de.pfabulist.roast.types.NonnullCheck;
import de.pfabulist.roast.types.functiontypes.Runnable_;
import de.pfabulist.roast.types.functiontypes.Supplier_;
import de.pfabulist.roast.unchecked.Unchecked;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayDeque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;

public final class Files_ {
    private Files_() {
    }

    public static Path_ createDirectory__(Path dir, FileAttribute<?> ... attrs) {
        return Path_.r_(Files_.createDirectory_(dir, attrs));
    }

    public static Path createDirectory(@Nullable Path tgt, FileAttribute<?> ... attrs) {
        return Files_.createDirectory_((Path)NonnullCheck.n_((Object)tgt), attrs);
    }

    public static Path createDirectory_(Path dir, FileAttribute<?> ... attrs) {
        return (Path)Supplier_.vn_(() -> Files.createDirectory(dir, attrs));
    }

    public static void createDirectories(@Nullable Path dir, FileAttribute<?> ... attrs) {
        Files_.createDirectories_((Path)NonnullCheck.n_((Object)dir), attrs);
    }

    public static void createDirectories_(Path dir, FileAttribute<?> ... attrs) {
        Supplier_.vn_(() -> Files.createDirectories(dir, attrs));
    }

    public static boolean exists_(Path path, LinkOption ... options) {
        return (Boolean)Supplier_.vn_(() -> Files.exists(path, options));
    }

    public static boolean exists(@Nullable Path path, LinkOption ... options) {
        return Files_.exists_((Path)NonnullCheck.n_((Object)path), options);
    }

    public static Path write(@Nullable Path path, @Nullable byte[] bytes, OpenOption ... options) {
        return Files_.write_((Path)NonnullCheck.n_((Object)path), (byte[])NonnullCheck.n_((Object)bytes), options);
    }

    public static Path write_(Path path, byte[] bytes, OpenOption ... options) {
        return (Path)Supplier_.vn_(() -> Files.write(path, bytes, options));
    }

    public static Stream<Path> list(@Nullable Path dir) {
        return Files_.list_((Path)NonnullCheck.n_((Object)dir));
    }

    public static Stream<Path> list_(Path dir) {
        return (Stream)Supplier_.vn_(() -> Files.list(dir));
    }

    public static DirectoryStream<Path> newDirectoryStream(@Nullable Path dir) {
        return Files_.newDirectoryStream_((Path)NonnullCheck.n_((Object)dir));
    }

    public static DirectoryStream<Path> newDirectoryStream_(Path dir) {
        return (DirectoryStream)Supplier_.vn_(() -> Files.newDirectoryStream(dir));
    }

    public static DirectoryStream_<Path> newDirectoryStream__(Path dir) {
        return DirectoryStream_.r_(Files_.newDirectoryStream(dir));
    }

    public static boolean isDirectory_(Path path, LinkOption ... options) {
        return (Boolean)Supplier_.vn_(() -> Files.isDirectory(path, options));
    }

    @Nullable
    public static FileTime getLastModifiedTime(@Nullable Path path, LinkOption ... options) {
        return Files_.getLastModifiedTime_((Path)NonnullCheck.n_((Object)path), options);
    }

    public static FileTime getLastModifiedTime_(Path path, LinkOption ... options) {
        return (FileTime)Supplier_.vn_(() -> Files.getLastModifiedTime(path, options));
    }

    public static FileTime getLastAccessTime(@Nullable Path path) {
        return Files_.getLastAccessTime_((Path)NonnullCheck.n_((Object)path), new LinkOption[0]);
    }

    public static FileTime getLastAccessTime_(Path path, LinkOption ... options) {
        return (FileTime)Supplier_.vn_(() -> (FileTime)NonnullCheck.n_((Object)Files_.readAttributes_(path, BasicFileAttributes.class, options).lastAccessTime()));
    }

    public static FileTime getCreationTime(@Nullable Path path, LinkOption ... options) {
        return Files_.getCreationTime_((Path)NonnullCheck.n_((Object)path), options);
    }

    public static FileTime getCreationTime_(Path path, LinkOption ... options) {
        return (FileTime)Supplier_.vn_(() -> (FileTime)NonnullCheck.n_((Object)Files_.readAttributes_(path, BasicFileAttributes.class, options).creationTime()));
    }

    public static <A extends BasicFileAttributes> A readAttributes(@Nullable Path path, @Nullable Class<A> type, LinkOption ... options) {
        return Files_.readAttributes_((Path)NonnullCheck.n_((Object)path), (Class)NonnullCheck.n_(type), (LinkOption[])NonnullCheck.n_((Object)options));
    }

    public static <A extends BasicFileAttributes> A readAttributes_(Path path, Class<A> type, LinkOption ... options) {
        return (A)((BasicFileAttributes)Supplier_.vn_(() -> Files.readAttributes(path, type, options)));
    }

    public static Map<String, Object> readAttributes(@Nullable Path path, @Nullable String attributes, LinkOption ... options) {
        return Files_.readAttributes_((Path)NonnullCheck.n_((Object)path), (String)NonnullCheck.n_((Object)attributes), options);
    }

    public static Map<String, Object> readAttributes_(Path path, String attributes, LinkOption ... options) {
        return (Map)NonnullCheck.n_((Object)((Map)Supplier_.vn_(() -> Files.readAttributes(path, attributes, options))));
    }

    public static Map_<String, Object> readAttributes__(Path path, String attributes, LinkOption ... options) {
        return Map_.r_((Map)NonnullCheck.n_((Object)((Map)Supplier_.vn_(() -> Files.readAttributes(path, attributes, options)))));
    }

    public static byte[] readAllBytes(@Nullable Path path) {
        return Files_.readAllBytes_((Path)NonnullCheck.n_((Object)path));
    }

    public static byte[] readAllBytes_(Path path) {
        return (byte[])Supplier_.vn_(() -> Files.readAllBytes(path));
    }

    public static SeekableByteChannel newByteChannel(@Nullable Path path, @Nullable Set<StandardOpenOption> standardOpenOptions, FileAttribute<?> ... attrs) {
        return Files_.newByteChannel_((Path)NonnullCheck.n_((Object)path), (Set)NonnullCheck.n_(standardOpenOptions), attrs);
    }

    public static SeekableByteChannel newByteChannel_(Path path, Set<StandardOpenOption> standardOpenOptions, FileAttribute<?> ... attrs) {
        return (SeekableByteChannel)Supplier_.vn_(() -> Files.newByteChannel(path, standardOpenOptions, attrs));
    }

    public static SeekableByteChannel_ newByteChannel__(Path path, Set<StandardOpenOption> standardOpenOptions, FileAttribute<?> ... attrs) {
        return SeekableByteChannel_.r_(Files_.newByteChannel_(path, standardOpenOptions, attrs));
    }

    public static SeekableByteChannel newByteChannel(@Nullable Path path, OpenOption ... options) {
        return Files_.newByteChannel_((Path)NonnullCheck.n_((Object)path), options);
    }

    public static SeekableByteChannel newByteChannel_(Path path, OpenOption ... options) {
        return (SeekableByteChannel)Supplier_.vn_(() -> Files.newByteChannel(path, options));
    }

    public static SeekableByteChannel_ newByteChannel__(Path path, OpenOption ... options) {
        return SeekableByteChannel_.r_(Files_.newByteChannel_(path, options));
    }

    public static long size(@Nullable Path target) {
        return Files_.size_((Path)NonnullCheck.n_((Object)target));
    }

    public static long size_(Path target) {
        return (Long)Supplier_.vn_(() -> Files.size(target));
    }

    public static Path copy(@Nullable Path src, @Nullable Path tgt, CopyOption ... options) {
        return Files_.copy_((Path)NonnullCheck.n_((Object)src), (Path)NonnullCheck.n_((Object)tgt), options);
    }

    public static Path copy_(Path src, Path tgt, CopyOption ... options) {
        return (Path)Supplier_.vn_(() -> Files.copy(src, tgt, options));
    }

    public static long copy_(Path source, OutputStream out) {
        return (Long)Supplier_.vn_(() -> Files.copy(source, out));
    }

    public static long copy(@Nullable Path source, @Nullable OutputStream out) {
        return Files_.copy_((Path)NonnullCheck.n_((Object)source), (OutputStream)NonnullCheck.n_((Object)out));
    }

    public static void delete(@Nullable Path path) {
        Files_.delete_((Path)NonnullCheck.n_((Object)path));
    }

    public static void delete_(Path path) {
        Runnable_.v_(() -> Files.delete(path));
    }

    public static void move(@Nullable Path src, @Nullable Path tgt, CopyOption ... options) {
        Files_.move_((Path)NonnullCheck.n_((Object)src), (Path)NonnullCheck.n_((Object)tgt), options);
    }

    public static void move_(Path src, Path tgt, CopyOption ... options) {
        Supplier_.vn_(() -> Files.move(src, tgt, options));
    }

    public static boolean deleteIfExists(@Nullable Path path) {
        return Files_.deleteIfExists_((Path)NonnullCheck.n_((Object)path));
    }

    public static boolean deleteIfExists_(Path path) {
        return (Boolean)Supplier_.vn_(() -> Files.deleteIfExists(path));
    }

    public static boolean isKid(@Nullable Path dir, @Nullable Path kid) {
        return Files_.isKid_((Path)NonnullCheck.n_((Object)dir), (Path)NonnullCheck.n_((Object)kid));
    }

    public static boolean isKid_(Path dir, Path kid) {
        return Files_.list_(dir).anyMatch(k -> k.equals(kid));
    }

    public static boolean isSymbolicLink(Path path) {
        return Files.isSymbolicLink(path);
    }

    public static void setLastModifiedTime(@Nullable Path file, @Nullable FileTime past) {
        Files_.setLastModifiedTime_((Path)NonnullCheck.n_((Object)file), (FileTime)NonnullCheck.n_((Object)past));
    }

    public static void setLastModifiedTime_(Path file, FileTime past) {
        Supplier_.vn_(() -> Files.setLastModifiedTime(file, past));
    }

    public static boolean isSameFile(@Nullable Path file, @Nullable Path file1) {
        return Files_.isSameFile_((Path)NonnullCheck.n_((Object)file), (Path)NonnullCheck.n_((Object)file1));
    }

    public static boolean isSameFile_(Path file, Path file1) {
        return (Boolean)Supplier_.vn_(() -> Files.isSameFile(file, file1));
    }

    public static Path createLink(@Nullable Path link, @Nullable Path existing) {
        return Files_.createLink_((Path)NonnullCheck.n_((Object)link), (Path)NonnullCheck.n_((Object)existing));
    }

    public static Path createLink_(Path link, Path existing) {
        return (Path)Supplier_.vn_(() -> Files.createLink(link, existing));
    }

    public static FileStore getFileStore(@Nullable Path path) {
        return Files_.getFileStore_((Path)NonnullCheck.n_((Object)path));
    }

    private static FileStore getFileStore_(Path path) {
        return (FileStore)Supplier_.vn_(() -> Files.getFileStore(path));
    }

    public static long copy(@Nullable InputStream is, @Nullable Path path, CopyOption ... options) {
        return Files_.copy_((InputStream)NonnullCheck.n_((Object)is), (Path)NonnullCheck.n_((Object)path), options);
    }

    public static long copy_(InputStream is, Path path, CopyOption ... options) {
        return (Long)Supplier_.vn_(() -> Files.copy(is, path, options));
    }

    public static InputStream newInputStream(Path jar, OpenOption ... options) {
        return (InputStream)Supplier_.vn_(() -> Files.newInputStream(jar, options));
    }

    public static Stream<String> lines(InputStream is, Charset cs) {
        CharsetDecoder decoder = cs.newDecoder();
        InputStreamReader reader = new InputStreamReader(is, decoder);
        BufferedReader br = new BufferedReader(reader);
        try {
            return (Stream)br.lines().onClose(Runnable_.e_(br::close));
        }
        catch (Error | RuntimeException e) {
            try {
                br.close();
            }
            catch (IOException ex) {
                try {
                    e.addSuppressed(ex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static void unzipToPath(InputStream is, Path root) {
        try (ZipInputStream zin = new ZipInputStream(is);){
            ZipEntry ze;
            while ((ze = zin.getNextEntry()) != null) {
                String name = ze.getName();
                Path target = (Path)NonnullCheck.n_((Object)root.resolve(name));
                if (name.endsWith("/")) {
                    Files_.createDirectories_(target, new FileAttribute[0]);
                } else {
                    Files_.copy(zin, target, new CopyOption[0]);
                }
                zin.closeEntry();
            }
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEmpty_(Path dir) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            boolean bl = !stream.iterator().hasNext();
            return bl;
        }
        catch (IOException e) {
            throw Unchecked.u((Throwable)e);
        }
    }

    public static boolean isRoot_(Path path) {
        return path.isAbsolute() && path.getParent() == null;
    }

    public static boolean isHidden_(Path resolve) {
        return (Boolean)Supplier_.vn_(() -> Files.isHidden(resolve));
    }

    public static UserPrincipal getOwner_(Path path, LinkOption ... options) {
        return (UserPrincipal)Supplier_.vn_(() -> Files.getOwner(path, options));
    }

    public static void setOwner_(Path path, UserPrincipal user) {
        Supplier_.vn_(() -> Files.setOwner(path, user));
    }

    public static Path setAttribute_(Path path, String attribute, Object value, LinkOption ... options) {
        Supplier_.vn_(() -> Files.setAttribute(path, attribute, value, options));
        return path;
    }

    public static <V extends FileAttributeView> Optional<V> getFileAttributeView_o(Path path, Class<V> type, LinkOption ... options) {
        return Optional.ofNullable(Files.getFileAttributeView(path, type, options));
    }

    public static <V extends FileAttributeView> V getFileAttributeView_ot(Path path, Class<V> type, LinkOption ... options) {
        return (V)((FileAttributeView)Files_.getFileAttributeView_o(path, type, options).orElseThrow(() -> new IllegalArgumentException("no such Attribute View " + type)));
    }

    public static void deleteRecursive_(Path path) {
        if (!Files_.exists_(path, new LinkOption[0])) {
            return;
        }
        ArrayDeque<Path> toDel = new ArrayDeque<Path>();
        if (Files_.isDirectory_(path, new LinkOption[0])) {
            Files_.walk_(path, new FileVisitOption[0]).forEach(toDel::addFirst);
        } else {
            toDel.add(path);
        }
        toDel.forEach(Files_::delete);
    }

    public static Stream<Path> walk_(Path start, FileVisitOption ... options) {
        return (Stream)Supplier_.vn_(() -> (Stream)NonnullCheck.n_(Files.walk(start, options)));
    }

    public static Stream<Path> walk(@Nullable Path start, FileVisitOption ... options) {
        return Files_.walk_((Path)NonnullCheck.n_((Object)start), options);
    }

    public static void copyRecursive_(Path src, Path target, CopyOption ... options) {
        if (!Files_.exists_(src, new LinkOption[0])) {
            return;
        }
        if (!Files_.isDirectory_(src, new LinkOption[0])) {
            Files_.copy(src, target, options);
            return;
        }
        Files_.walk_(src, new FileVisitOption[0]).forEach(kid -> {
            Path to = (Path)NonnullCheck.n_((Object)target.resolve(src.relativize((Path)kid)));
            Files_.copy(kid, to, options);
        });
    }

    public static Path createSymbolicLink_(Path link, Path target, FileAttribute<?> ... attrs) {
        return (Path)Supplier_.vn_(() -> Files.createSymbolicLink(link, target, attrs));
    }

    public static Path createSymbolicLink(@Nullable Path link, @Nullable Path target, FileAttribute<?> ... attrs) {
        return Files_.createSymbolicLink_((Path)NonnullCheck.n_((Object)link), (Path)NonnullCheck.n_((Object)target), attrs);
    }

    public static Path readSymbolicLink_(Path path) {
        return (Path)Supplier_.vn_(() -> Files.readSymbolicLink(path));
    }

    public static Path readSymbolicLink(@Nullable Path path) {
        return Files_.readSymbolicLink_((Path)NonnullCheck.n_((Object)path));
    }

    public static Path createFile_(Path path, FileAttribute<?> ... attrs) {
        return (Path)Supplier_.vn_(() -> Files.createFile(path, attrs));
    }

    public static Path createFile(@Nullable Path path, FileAttribute<?> ... attrs) {
        return Files_.createFile_((Path)NonnullCheck.n_((Object)path), attrs);
    }

    public static OutputStream newOutputStream_(Path path, OpenOption ... options) {
        return (OutputStream)Supplier_.vn_(() -> Files.newOutputStream(path, options));
    }

    public static OutputStream newOutputStream(@Nullable Path path, OpenOption ... options) {
        return Files_.newOutputStream_((Path)NonnullCheck.n_((Object)path), options);
    }
}

