/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.roast.nio;

import de.pfabulist.roast.nio.FileSystemProvider_;
import de.pfabulist.roast.types.NonnullCheck;
import de.pfabulist.roast.types.functiontypes.Runnable_;
import de.pfabulist.roast.types.functiontypes.Supplier_;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public class FileSystemProvider_of
implements FileSystemProvider_ {
    private final FileSystemProvider inner;

    public FileSystemProvider_of(FileSystemProvider fileSystem) {
        this.inner = fileSystem;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileSystemProvider_of that = (FileSystemProvider_of)o;
        return this.inner.equals(that.inner);
    }

    public int hashCode() {
        return this.inner.hashCode();
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes_(Path path, Class<A> type, LinkOption ... options) {
        return (A)((BasicFileAttributes)Supplier_.vn_(() -> (BasicFileAttributes)NonnullCheck.n_(this.inner.readAttributes(path, type, options))));
    }

    @Override
    public Map<String, Object> readAttributes_(Path path, String attributes, LinkOption ... options) {
        return (Map)Supplier_.vn_(() -> (Map)NonnullCheck.n_(this.inner.readAttributes(path, attributes, options)));
    }

    @Override
    public SeekableByteChannel newByteChannel_(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        return (SeekableByteChannel)Supplier_.vn_(() -> (SeekableByteChannel)NonnullCheck.n_((Object)this.inner.newByteChannel(path, options, attrs)));
    }

    @Override
    public void copy_(Path src, Path tgt, CopyOption ... options) {
        Runnable_.v_(() -> this.inner.copy(src, tgt, options));
    }

    @Override
    public void move_(Path src, Path tgt, CopyOption ... options) {
        Runnable_.v_(() -> this.inner.move(src, tgt, options));
    }

    @Override
    public String getScheme() {
        return (String)NonnullCheck.n_((Object)this.inner.getScheme());
    }

    @Override
    public FileSystem newFileSystem_(URI uri, Map<String, ?> env) {
        return (FileSystem)Supplier_.vn_(() -> (FileSystem)NonnullCheck.n_((Object)this.inner.newFileSystem(uri, env)));
    }

    @Override
    public FileSystem getFileSystem_(URI uri) {
        return (FileSystem)Supplier_.vn_(() -> (FileSystem)NonnullCheck.n_((Object)this.inner.getFileSystem(uri)));
    }

    @Override
    public <V extends FileAttributeView> Optional<V> getFileAttributeView_o(Path path, Class<V> type, LinkOption ... options) {
        return (Optional)Supplier_.vn_(() -> Optional.ofNullable(this.inner.getFileAttributeView(path, type, options)));
    }

    @Override
    public void setAttribute_(Path path, String attribute, Object value, LinkOption ... options) {
        Runnable_.v_(() -> this.inner.setAttribute(path, attribute, value, options));
    }

    @Override
    public boolean isSameFile_(Path a, Path b) {
        return (Boolean)Supplier_.vn_(() -> this.inner.isSameFile(a, b));
    }

    @Override
    public void checkAccess_(Path file, AccessMode ... modes) {
        Runnable_.v_(() -> this.inner.checkAccess(file, modes));
    }

    @Override
    public void createDirectory_(Path dir, FileAttribute<?> ... attrs) {
        Runnable_.v_(() -> this.inner.createDirectory(dir, attrs));
    }

    @Override
    public void delete_(Path path) {
        Runnable_.v_(() -> this.inner.delete(path));
    }

    @Override
    public boolean deleteIfExists_(Path path) {
        return (Boolean)Supplier_.vn_(() -> this.inner.deleteIfExists(path));
    }

    @Override
    public FileStore getFileStore_(Path file) {
        return (FileStore)Supplier_.vn_(() -> (FileStore)NonnullCheck.n_((Object)this.inner.getFileStore(file)));
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream_(Path dir, DirectoryStream.Filter<? super Path> filter) {
        return (DirectoryStream)Supplier_.vn_(() -> this.inner.newDirectoryStream(dir, filter));
    }

    @Override
    public FileChannel newFileChannel_(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        return (FileChannel)Supplier_.vn_(() -> this.inner.newFileChannel(path, options, attrs));
    }

    @Override
    public void createSymbolicLink_(Path linkArg, Path target, FileAttribute<?> ... attrs) {
        Runnable_.v_(() -> this.inner.createSymbolicLink(linkArg, target, attrs));
    }

    @Override
    public void createLink_(Path linkArg, Path existingArg) {
        Runnable_.v_(() -> this.inner.createLink(linkArg, existingArg));
    }

    @Override
    public Path readSymbolicLink_(Path linkArg) {
        return (Path)Supplier_.vn_(() -> this.inner.readSymbolicLink(linkArg));
    }

    public FileSystemProvider _r() {
        return this.inner;
    }
}

