/*
 * Decompiled with CFR 0.152.
 */
package de.pfabulist.nonnullbydefault;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NonnullCheck {
    private static final Logger logger = LoggerFactory.getLogger((String)NonnullCheck.class.getPackage().getName());

    private NonnullCheck() {
    }

    @Nonnull
    public static <T> T _nc(@Nullable T a) {
        if (a == null) {
            logger.warn("collection member is null (java allowed but not here): " + NonnullCheck.getProblemMethod());
            throw new NullPointerException("collection member is null (java allowed but not here)");
        }
        return a;
    }

    @Nonnull
    public static <T> T _nn(@Nullable T a) {
        if (a == null) {
            logger.warn("unexpected null at: " + NonnullCheck.getProblemMethod());
            throw new NullPointerException("unexpected null");
        }
        return a;
    }

    @Nonnull
    public static <T> T _n0(@Nullable T a) {
        if (a == null) {
            logger.warn("parameter number 0 == null: " + NonnullCheck.getProblemMethod());
            throw new NullPointerException("parameter number 0 == null");
        }
        return a;
    }

    @Nonnull
    public static <T> T _n1(@Nullable T a) {
        if (a == null) {
            logger.warn("parameter number 1 == null" + NonnullCheck.getProblemMethod());
            throw new NullPointerException("parameter number 1 == null");
        }
        return a;
    }

    @Nonnull
    public static <T> T _n2(@Nullable T a) {
        if (a == null) {
            logger.warn("parameter number 2 == null " + NonnullCheck.getProblemMethod());
            throw new NullPointerException("parameter number 2 == null");
        }
        return a;
    }

    @Nonnull
    public static <T> T[] _nargs(T ... args) {
        if (args == null) {
            logger.warn("var args array is null " + NonnullCheck.getProblemMethod());
            throw new NullPointerException("var args array is null");
        }
        int i = 0;
        for (T arg : args) {
            if (arg == null) {
                logger.warn("var args parameter number " + i + " == null");
                throw new NullPointerException("var args parameter number " + i + " == null");
            }
            ++i;
        }
        return args;
    }

    @Nonnull
    public static <T> T _ni(@Nullable T a) {
        if (a == null) {
            logger.warn("injected value is null (config bug)" + NonnullCheck.getProblemMethod());
            throw new NullPointerException("injected value is null");
        }
        return a;
    }

    public static String getProblemMethod() {
        IllegalArgumentException ex = new IllegalArgumentException("foo");
        StackTraceElement[] stack = ex.getStackTrace();
        if (stack.length < 3) {
            return "not called as indented, i.e. part of _nX";
        }
        return stack[2].toString();
    }

    @Nonnull
    public static <T, E extends Throwable> T _orElseExpectedThrow(@Nullable T t, @Nonnull SupplierNN<E> exceptionSupplier) throws E {
        if (t == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        return t;
    }

    @Nonnull
    public static <T, E extends Throwable> T _orElseThrow(@Nullable T t, @Nonnull SupplierNN<E> exceptionSupplier) throws E {
        if (t == null) {
            logger.warn("value is null " + NonnullCheck.getProblemMethod());
            throw (Throwable)exceptionSupplier.get();
        }
        return t;
    }

    @Nonnull
    public static <T> T _orElseGet(@Nullable T t, @Nonnull T e) {
        if (t == null) {
            return e;
        }
        return t;
    }

    @Nonnull
    public static <T> T _orElseGet(@Nullable T t, @Nonnull SupplierNN<T> supp) {
        if (t == null) {
            return supp.get();
        }
        return t;
    }

    @FunctionalInterface
    public static interface SupplierNN<E> {
        @Nonnull
        public E get();
    }
}

