package de.pfabulist.nonnullbydefault;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.function.Supplier;

/**
 * Copyright (c) 2006 - 2016, Stephan Pfab
 * SPDX-License-Identifier: BSD-2-Clause
 */

public final class NonnullCheck {

    private NonnullCheck() {
    }

    private final static org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger( NonnullCheck.class.getPackage().getName() );

    public
    @Nonnull
    static <T> T _nc( @Nullable T a ) {
        if( a == null ) {
            logger.warn( "collection member is null (java allowed but not here): " + getProblemMethod() );
            throw new NullPointerException( "collection member is null (java allowed but not here)" );
        }
        return a;
    }

    public
    @Nonnull
    static <T> T _nn( @Nullable T a ) {
        if( a == null ) {
            logger.warn( "unexpected null at: " + getProblemMethod() );
            throw new NullPointerException( "unexpected null" );
        }
        return a;
    }

    public
    @Nonnull
    static <T> T _n0( @Nullable T a ) {
        if( a == null ) {
            logger.warn( "parameter number 0 == null: " + getProblemMethod() );
            throw new NullPointerException( "parameter number 0 == null" );
        }
        return a;
    }

    public
    @Nonnull
    static <T> T _n1( @Nullable T a ) {
        if( a == null ) {
            logger.warn( "parameter number 1 == null" + getProblemMethod() );
            throw new NullPointerException( "parameter number 1 == null" );
        }
        return a;
    }

    public
    @Nonnull
    static <T> T _n2( @Nullable T a ) {
        if( a == null ) {
            logger.warn( "parameter number 2 == null " + getProblemMethod() );
            throw new NullPointerException( "parameter number 2 == null" );
        }
        return a;
    }

    public
    @Nonnull
    static <T> T[] _nargs( @Nullable T... args ) {
        if( args == null ) {
            logger.warn( "var args array is null " + getProblemMethod() );
            throw new NullPointerException( "var args array is null" );
        }

        int i = 0;
        for( T arg : args ) {
            if( arg == null ) {
                logger.warn( "var args parameter number " + i + " == null" );
                throw new NullPointerException( "var args parameter number " + i + " == null" );
            }
            i++;
        }

        return args;
    }

    public
    @Nonnull
    static <T> T _ni( @Nullable T a ) {
        if( a == null ) {
            logger.warn( "injected value is null (config bug)" + getProblemMethod() );
            throw new NullPointerException( "injected value is null" );

        }
        return a;
    }

    @SuppressWarnings( "ConstantConditions" )
    public static String getProblemMethod() {
        Exception ex = new IllegalArgumentException( "foo" );
        StackTraceElement[] stack = ex.getStackTrace();
        if( stack.length < 3 ) {
            return "not called as indented, i.e. part of _nX";
        }

        return stack[ 2 ].toString();
    }

    @FunctionalInterface
    public interface SupplierNN<E> {
        @Nonnull E get();
    }

    public static
    @Nonnull
    <T, E extends Exception> T _orElseExpectedThrow( @Nullable T t, SupplierNN<E> exceptionSupplier ) throws E {
        if( t == null ) {
            //noinspection ConstantConditions
            throw exceptionSupplier.get();
        }

        return t;
    }

    public static
    @Nonnull
    <T, E extends Exception> T _orElseThrow( @Nullable T t, @Nonnull SupplierNN<E> exceptionSupplier ) throws E {
        if( t == null ) {
            logger.warn( "value is null " + getProblemMethod() );
            throw exceptionSupplier.get();
        }

        return t;
    }

    public static
    @Nonnull
    <T> T _orElseGet( @Nullable T t, @Nonnull T e ) {
        if( t == null ) {
            return e;
        }

        return t;
    }

    public static
    @Nonnull
    <T> T _orElseGet( @Nullable T t, @Nonnull SupplierNN<T> supp) {
        if( t == null ) {
            return supp.get();
        }

        return t;
    }
}
